/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanParameterInspection
extends BaseInspection {
    public boolean onlyReportMultiple = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("boolean.parameter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        int booleanParameterCount = (Integer)infos[1];
        if (booleanParameterCount == 1) {
            return method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameter.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameter.problem.descriptor", new Object[0]);
        }
        return method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameters.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameters.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("boolean.parameter.only.report.multiple.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportMultiple");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanParameterVisitor();
    }

    private class BooleanParameterVisitor
    extends BaseInspectionVisitor {
        private BooleanParameterVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiParameter parameter2;
            PsiType type2;
            PsiClass aClass;
            super.visitMethod(method);
            if (!(method.hasModifierProperty("public") || (aClass = method.getContainingClass()) != null && aClass.isInterface())) {
                return;
            }
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) || LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            int count = 0;
            PsiParameter[] psiParameterArray = parameters2;
            int n = psiParameterArray.length;
            for (int i = 0; i < n && (!PsiType.BOOLEAN.equals((Object)(type2 = (parameter2 = psiParameterArray[i]).getType())) || MethodCallUtils.isUsedAsSuperConstructorCallArgument(parameter2, true) || ++count <= 1); ++i) {
            }
            if (count == 0 || BooleanParameterInspection.this.onlyReportMultiple && count == 1) {
                return;
            }
            this.registerMethodError(method, method, count);
        }
    }
}

