/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeMayBeWeakenedInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean useRighthandTypeAsWeakestTypeInAssignments = true;
    public boolean useParameterizedTypeForCollectionMethods = true;
    public boolean doNotWeakenToJavaLangObject = true;
    public boolean onlyWeakentoInterface = true;
    public boolean doNotWeakenReturnType = true;
    public boolean doNotWeakenInferredVariableType;
    public OrderedSet<String> myStopClassSet = new OrderedSet();
    private final ListWrappingTableModel myStopClassesModel = new ListWrappingTableModel(this.myStopClassSet, InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.table", new Object[0]));

    public void readSettings(@NotNull Element node) {
        List options = node.getChildren("option");
        HashMap<String, String> values = new HashMap<String, String>();
        for (Element option : options) {
            Attribute valueAttribute;
            Attribute nameAttribute = option.getAttribute("name");
            if (nameAttribute == null || (valueAttribute = option.getAttribute("value")) == null) continue;
            values.put(nameAttribute.getValue(), valueAttribute.getValue());
        }
        this.useRighthandTypeAsWeakestTypeInAssignments = TypeMayBeWeakenedInspection.readOrDefault(values, "useRighthandTypeAsWeakestTypeInAssignments", this.useRighthandTypeAsWeakestTypeInAssignments);
        this.useParameterizedTypeForCollectionMethods = TypeMayBeWeakenedInspection.readOrDefault(values, "useParameterizedTypeForCollectionMethods", this.useParameterizedTypeForCollectionMethods);
        this.doNotWeakenToJavaLangObject = TypeMayBeWeakenedInspection.readOrDefault(values, "doNotWeakenToJavaLangObject", this.doNotWeakenToJavaLangObject);
        this.onlyWeakentoInterface = TypeMayBeWeakenedInspection.readOrDefault(values, "onlyWeakentoInterface", this.onlyWeakentoInterface);
        this.doNotWeakenReturnType = TypeMayBeWeakenedInspection.readOrDefault(values, "doNotWeakenReturnType", this.doNotWeakenReturnType);
        this.doNotWeakenInferredVariableType = TypeMayBeWeakenedInspection.readOrDefault(values, "doNotWeakenInferredVariableType", this.doNotWeakenInferredVariableType);
        this.readStopClasses(node);
    }

    private static boolean readOrDefault(@NotNull Map<String, String> options, @NotNull String name, boolean defaultValue) {
        String value2 = options.get(name);
        if (value2 == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value2);
    }

    private void readStopClasses(@NotNull Element node) {
        List classes2 = node.getChildren("stopClasses");
        if (classes2.isEmpty()) {
            return;
        }
        Element element = (Element)classes2.get(0);
        List contentList = element.getContent();
        if (contentList.isEmpty()) {
            return;
        }
        String text2 = ((Content)contentList.get(0)).getValue();
        this.myStopClassSet.addAll(Arrays.asList(text2.split(",")));
    }

    public void writeSettings(@NotNull Element node) {
        TypeMayBeWeakenedInspection.writeBool(node, this.useRighthandTypeAsWeakestTypeInAssignments, "useRighthandTypeAsWeakestTypeInAssignments");
        TypeMayBeWeakenedInspection.writeBool(node, this.useParameterizedTypeForCollectionMethods, "useParameterizedTypeForCollectionMethods");
        TypeMayBeWeakenedInspection.writeBool(node, this.doNotWeakenToJavaLangObject, "doNotWeakenToJavaLangObject");
        TypeMayBeWeakenedInspection.writeBool(node, this.onlyWeakentoInterface, "onlyWeakentoInterface");
        if (!this.doNotWeakenReturnType) {
            TypeMayBeWeakenedInspection.writeBool(node, false, "doNotWeakenReturnType");
        }
        if (this.doNotWeakenInferredVariableType) {
            TypeMayBeWeakenedInspection.writeBool(node, true, "doNotWeakenInferredVariableType");
        }
        if (!this.myStopClassSet.isEmpty()) {
            Element stopClasses = new Element("stopClasses");
            stopClasses.addContent(String.join((CharSequence)",", this.myStopClassSet));
            node.addContent(stopClasses);
        }
    }

    private static void writeBool(@NotNull Element node, boolean value2, @NotNull String name) {
        Element optionElement = new Element("option");
        optionElement.setAttribute("name", name);
        optionElement.setAttribute("value", String.valueOf(value2));
        node.addContent(optionElement);
    }

    private void addClass(final @NotNull String stopClass, @NotNull PsiElement context) {
        if (this.myStopClassSet.add((Object)stopClass)) {
            final Project project = context.getProject();
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)context);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

                public void undo() {
                    TypeMayBeWeakenedInspection.this.myStopClassSet.remove((Object)stopClass);
                    ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                }

                public void redo() {
                    TypeMayBeWeakenedInspection.this.myStopClassSet.add((Object)stopClass);
                    ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                }

                public boolean isGlobal() {
                    return true;
                }
            });
        }
    }

    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.display.name", new Object[0]);
    }

    private static String getClassName(@NotNull PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName == null ? aClass.getName() : qualifiedName;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        VerticalBox verticalBox = new VerticalBox();
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.ignore.option", new Object[0]), "useRighthandTypeAsWeakestTypeInAssignments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.collection.method.option", new Object[0]), "useParameterizedTypeForCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.to.object.option", new Object[0]), "doNotWeakenToJavaLangObject");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.only.weaken.to.an.interface", new Object[0]), "onlyWeakentoInterface");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.return.type", new Object[0]), "doNotWeakenReturnType");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.inferred.variable.type", new Object[0]), "doNotWeakenInferredVariableType");
        verticalBox.add((Component)optionsPanel);
        ListTable stopClassesTable = new ListTable(this.myStopClassesModel);
        JPanel stopClassesPanel = UiUtils.createAddRemoveTreeClassChooserPanel(stopClassesTable, InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.table", new Object[0]), "java.lang.Object");
        verticalBox.add((Component)stopClassesPanel);
        return ScrollPaneFactory.createScrollPane((Component)verticalBox, (boolean)true);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new TypeMayBeWeakenedVisitor(holder, isOnTheFly);
    }

    @NotNull
    private static PsiClass tryReplaceWithParentStopper(@NotNull PsiClass fromIncl, @NotNull PsiClass toIncl, @NotNull Collection<String> stopClasses) {
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)fromIncl)) {
            if (!superClass.isInheritor(toIncl, true) || !stopClasses.contains(TypeMayBeWeakenedInspection.getClassName(superClass))) continue;
            return superClass;
        }
        return toIncl;
    }

    @NotNull
    private static List<String> getInheritors(@NotNull PsiClass from, @NotNull PsiClass to) {
        ArrayList<String> candidates = new ArrayList<String>();
        String fromName = TypeMayBeWeakenedInspection.getClassName(from);
        if (fromName != null) {
            candidates.add(fromName);
        }
        for (PsiClass cls : InheritanceUtil.getSuperClasses((PsiClass)from)) {
            String name;
            if (!cls.isInheritor(to, true) || (name = TypeMayBeWeakenedInspection.getClassName(cls)) == null) continue;
            candidates.add(name);
        }
        return candidates;
    }

    private class TypeMayBeWeakenedVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        TypeMayBeWeakenedVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitVariable(PsiVariable variable) {
            PsiMethod method;
            PsiExpression initializer;
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue2;
            PsiElement parent;
            PsiTypeElement typeElement;
            super.visitVariable(variable);
            if (variable instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)variable;
                PsiElement declarationScope = parameter2.getDeclarationScope();
                if (declarationScope instanceof PsiCatchSection) {
                    return;
                }
                if (declarationScope instanceof PsiLambdaExpression && parameter2.getTypeElement() == null) {
                    return;
                }
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)declarationScope;
                    PsiClass containingClass = method2.getContainingClass();
                    if (containingClass == null || containingClass.isInterface()) {
                        return;
                    }
                    if (JavaHighlightUtil.isSerializationRelatedMethod(method2, containingClass)) {
                        return;
                    }
                    if (MethodUtils.hasSuper(method2)) {
                        return;
                    }
                    Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method2);
                    if (overridingSearch.findFirst() != null) {
                        return;
                    }
                }
            }
            if (this.myIsOnTheFly && variable instanceof PsiField && !variable.hasModifierProperty("private")) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.doNotWeakenInferredVariableType && (typeElement = variable.getTypeElement()) != null && typeElement.isInferredType()) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments && (variable instanceof PsiParameter ? (parent = variable.getParent()) instanceof PsiForeachStatement && !((iteratedValue2 = (foreachStatement = (PsiForeachStatement)parent).getIteratedValue()) instanceof PsiNewExpression) && !(iteratedValue2 instanceof PsiTypeCastExpression) : !((initializer = variable.getInitializer()) instanceof PsiNewExpression) && !(initializer instanceof PsiTypeCastExpression))) {
                return;
            }
            if (variable instanceof PsiParameter && ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class)) == null || UnusedSymbolUtil.isImplicitUsage(variable.getProject(), (PsiModifierListOwner)method, null))) {
                return;
            }
            if (UnusedSymbolUtil.isImplicitWrite(variable) || UnusedSymbolUtil.isImplicitRead(variable)) {
                return;
            }
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)variable.getType(), PsiClassType.class);
            if (classType == null) {
                return;
            }
            PsiClass originClass = classType.resolve();
            if (originClass == null) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.myStopClassSet.contains((Object)TypeMayBeWeakenedInspection.getClassName(originClass))) {
                return;
            }
            Collection<PsiClass> weakestClasses = this.computeWeakestClasses((PsiElement)variable, originClass);
            if (weakestClasses.isEmpty()) {
                return;
            }
            PsiIdentifier nameIdentifier = variable.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerProblem((PsiElement)nameIdentifier, (PsiElement)variable, originClass, weakestClasses);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenReturnType) {
                return;
            }
            if (this.myIsOnTheFly && !method.hasModifierProperty("private") && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method);
            if (overridingSearch.findFirst() != null) {
                return;
            }
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)method.getReturnType(), PsiClassType.class);
            if (classType == null) {
                return;
            }
            PsiClass originClass = classType.resolve();
            if (originClass == null) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.myStopClassSet.contains((Object)TypeMayBeWeakenedInspection.getClassName(originClass))) {
                return;
            }
            Collection<PsiClass> weakestClasses = this.computeWeakestClasses((PsiElement)method, originClass);
            if (weakestClasses.isEmpty()) {
                return;
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            this.registerProblem((PsiElement)identifier, (PsiElement)method, originClass, weakestClasses);
        }

        @NotNull
        private Collection<PsiClass> computeWeakestClasses(@NotNull PsiElement element, @NotNull PsiClass originClass) {
            List weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary(element, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                weakestClasses.remove(ClassUtils.findObjectClass(element));
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                weakestClasses.removeIf(weakestClass -> !weakestClass.isInterface());
            }
            weakestClasses = ContainerUtil.map(weakestClasses, psiClass -> TypeMayBeWeakenedInspection.tryReplaceWithParentStopper(originClass, psiClass, TypeMayBeWeakenedInspection.this.myStopClassSet));
            return weakestClasses;
        }

        private void registerProblem(@NotNull PsiElement psiElement, @NotNull PsiElement element, @NotNull PsiClass originalClass, @NotNull Collection<PsiClass> weakerClasses) {
            PsiTypeElement typeElement;
            ArrayList<Object> fixes = new ArrayList<Object>();
            if (element instanceof PsiVariable && !TypeMayBeWeakenedInspection.this.doNotWeakenInferredVariableType && (typeElement = ((PsiVariable)element).getTypeElement()) != null && typeElement.isInferredType()) {
                fixes.add(new SetInspectionOptionFix((LocalInspectionTool)TypeMayBeWeakenedInspection.this, "doNotWeakenInferredVariableType", InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.inferred.variable.type", new Object[0]), true));
            }
            for (PsiClass weakestClass : weakerClasses) {
                String className = TypeMayBeWeakenedInspection.getClassName(weakestClass);
                if (className == null) continue;
                fixes.add(new TypeMayBeWeakenedFix(className));
                List candidates = TypeMayBeWeakenedInspection.getInheritors(originalClass, weakestClass);
                candidates.removeAll((Collection<?>)TypeMayBeWeakenedInspection.this.myStopClassSet);
                if (candidates.isEmpty() || !this.myIsOnTheFly && candidates.size() != 1) continue;
                fixes.add(new AddStopWordQuickfix(candidates));
            }
            this.myHolder.registerProblem(psiElement, this.getDescription(element, weakerClasses), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        @NotNull
        private String getDescription(@NotNull PsiElement element, @NotNull Collection<PsiClass> weakerClasses) {
            StringBuilder builder = new StringBuilder();
            Iterator<PsiClass> iterator = weakerClasses.iterator();
            if (iterator.hasNext()) {
                builder.append('\'').append(TypeMayBeWeakenedInspection.getClassName(iterator.next())).append('\'');
                while (iterator.hasNext()) {
                    builder.append(", '").append(TypeMayBeWeakenedInspection.getClassName(iterator.next())).append('\'');
                }
            }
            if (element instanceof PsiField) {
                return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.field.problem.descriptor", builder.toString());
            }
            if (element instanceof PsiParameter) {
                return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.parameter.problem.descriptor", builder.toString());
            }
            if (element instanceof PsiMethod) {
                return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.method.problem.descriptor", builder.toString());
            }
            return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.problem.descriptor", builder.toString());
        }
    }

    private static class TypeMayBeWeakenedFix
    implements LocalQuickFix {
        private final String fqClassName;

        TypeMayBeWeakenedFix(@NotNull String fqClassName) {
            this.fqClassName = fqClassName;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.quickfix", this.fqClassName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.weaken.type.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement replacement;
            PsiTypeParameter[] typeParameters;
            PsiTypeElement typeElement;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                typeElement = variable.getTypeElement();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                typeElement = method.getReturnTypeElement();
            } else {
                return;
            }
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement componentReferenceElement = typeElement.getInnermostComponentReferenceElement();
            boolean isInferredType = typeElement.isInferredType();
            if (componentReferenceElement == null && !isInferredType) {
                return;
            }
            PsiType oldType = typeElement.getType();
            if (!(oldType instanceof PsiClassType)) {
                return;
            }
            PsiClassType oldClassType = (PsiClassType)oldType;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiType type2 = factory.createTypeFromText(this.fqClassName, element);
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass != null && (typeParameters = aClass.getTypeParameters()).length != 0) {
                PsiClass newClass = classType.resolve();
                if (newClass == null) {
                    return;
                }
                HashMap<PsiTypeParameter, PsiType> typeParameterMap = new HashMap<PsiTypeParameter, PsiType>();
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeParameter typeParameter = typeParameters[i];
                    PsiType parameterType = PsiUtil.substituteTypeParameter((PsiType)oldClassType, (PsiClass)newClass, (int)i, (boolean)false);
                    typeParameterMap.put(typeParameter, parameterType);
                }
                PsiSubstitutor substitutor = factory.createSubstitutor(typeParameterMap);
                classType = factory.createType(aClass, substitutor);
            }
            if (isInferredType) {
                PsiTypeElement newTypeElement = factory.createTypeElement((PsiType)classType);
                replacement = new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, (PsiElement)newTypeElement);
            } else {
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
                replacement = new CommentTracker().replaceAndRestoreComments((PsiElement)componentReferenceElement, (PsiElement)referenceElement);
            }
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            javaCodeStyleManager.shortenClassReferences(replacement);
        }
    }

    class AddStopWordQuickfix
    implements LowPriorityAction,
    LocalQuickFix {
        private final List<String> myCandidates;

        AddStopWordQuickfix(List<String> candidates) {
            this.myCandidates = candidates;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myCandidates.size() == 1) {
                InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper.single", this.myCandidates.get(0));
            }
            return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper", new Object[0]);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.family", new Object[0]);
        }

        public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
            if (this.myCandidates.size() == 1) {
                TypeMayBeWeakenedInspection.this.addClass(this.myCandidates.get(0), descriptor.getPsiElement());
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            String hint = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.popup", new Object[0]);
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(hint, this.myCandidates){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    CommandProcessor.getInstance().executeCommand(project, () -> TypeMayBeWeakenedInspection.this.addClass(selectedValue, descriptor.getPsiElement()), InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper", new Object[0]), null);
                    return super.onChosen((Object)selectedValue, finalChoice);
                }
            });
            popup.showInBestPositionFor(editor);
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

