/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.asserttoif;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfCanBeAssertionInspection
extends BaseInspection {
    private static final String GUAVA_PRECONDITIONS = "com.google.common.base.Preconditions";
    private static final String GUAVA_CHECK_NON_NULL = "checkNotNull";

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("if.can.be.assertion.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfToAssertionVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        boolean isObjectsRequireNonNullAvailable = (Boolean)infos[0];
        boolean isIfStatement = (Boolean)infos[1];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>(2);
        if (isObjectsRequireNonNullAvailable) {
            fixes.add(new ReplaceWithObjectsNonNullFix(isIfStatement));
        }
        if (isIfStatement) {
            fixes.add(new IfToAssertionFix());
        }
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    static PsiNewExpression getThrownNewException(PsiElement element) {
        PsiThrowStatement throwStatement;
        PsiExpression exception;
        if (element instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)element).getCodeBlock().getStatements();
            if (statements.length == 1) {
                return IfCanBeAssertionInspection.getThrownNewException((PsiElement)statements[0]);
            }
        } else if (element instanceof PsiThrowStatement && (exception = ParenthesesUtils.stripParentheses((throwStatement = (PsiThrowStatement)element).getException())) instanceof PsiNewExpression) {
            return (PsiNewExpression)exception;
        }
        return null;
    }

    private static class IfToAssertionFix
    extends InspectionGadgetsFix {
        private IfToAssertionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("if.can.be.assertion.replace.with.assertion.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement parent = descriptor.getPsiElement().getParent();
            if (!(parent instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            StringBuilder newStatementText = new StringBuilder("assert ");
            CommentTracker tracker = new CommentTracker();
            newStatementText.append(BoolUtils.getNegatedExpressionText(ifStatement.getCondition(), tracker));
            PsiNewExpression newException = IfCanBeAssertionInspection.getThrownNewException((PsiElement)ifStatement.getThenBranch());
            String message2 = IfToAssertionFix.getExceptionMessage(newException, tracker);
            if (message2 != null) {
                newStatementText.append(':').append(message2);
            }
            newStatementText.append(';');
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatementText.toString(), tracker);
        }

        private static String getExceptionMessage(PsiNewExpression newExpression, CommentTracker tracker) {
            if (newExpression == null) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 1) {
                return null;
            }
            return tracker.text((PsiElement)arguments[0]);
        }
    }

    private static class ReplaceWithObjectsNonNullFix
    extends InspectionGadgetsFix {
        private final boolean myIsIfStatement;

        ReplaceWithObjectsNonNullFix(boolean isIfStatement) {
            this.myIsIfStatement = isIfStatement;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("if.can.be.assertion.replace.with.objects.requirenonnull.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            Replacer info = this.getReplaceInfo(descriptor);
            if (info == null) {
                return;
            }
            info.replace();
        }

        @Nullable
        private Replacer getReplaceInfo(ProblemDescriptor descriptor) {
            if (this.myIsIfStatement) {
                PsiElement parent = descriptor.getPsiElement().getParent();
                if (!(parent instanceof PsiIfStatement)) {
                    return null;
                }
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                PsiExpression condition2 = ifStatement.getCondition();
                if (!(condition2 instanceof PsiBinaryExpression)) {
                    return null;
                }
                PsiExpression nullComparedExpression = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)condition2);
                if (nullComparedExpression == null) {
                    return null;
                }
                CommentTracker tracker = new CommentTracker();
                return new Replacer(text2 -> PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)ifStatement, text2 + ";", tracker), tracker.markUnchanged(nullComparedExpression), null);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement().getParent(), PsiReferenceExpression.class);
            if (ref == null) {
                return null;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
            if (methodCall == null || !MethodCallUtils.isCallToMethod(methodCall, IfCanBeAssertionInspection.GUAVA_PRECONDITIONS, null, IfCanBeAssertionInspection.GUAVA_CHECK_NON_NULL, (PsiType[])null)) {
                return null;
            }
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            if (args.length > 2) {
                return null;
            }
            CommentTracker tracker = new CommentTracker();
            return new Replacer(text2 -> PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCall, text2, tracker), tracker.markUnchanged(args[0]), args.length == 2 ? tracker.markUnchanged(args[1]) : null);
        }

        private static class Replacer {
            private final Consumer<? super String> myReplacer;
            private final PsiExpression myNullComparedExpression;
            private final PsiExpression myMessage;

            private Replacer(@NotNull Consumer<? super String> replacer, @NotNull PsiExpression nullComparedExpression, @Nullable PsiExpression message2) {
                this.myReplacer = replacer;
                this.myNullComparedExpression = nullComparedExpression;
                this.myMessage = message2;
            }

            public void replace() {
                String messageText;
                if (this.myMessage == null) {
                    messageText = "";
                } else {
                    PsiType messageType = this.myMessage.getType();
                    messageText = ", " + (messageType != null && messageType.equalsToText("java.lang.String") ? this.myMessage.getText() : "java.lang.String.valueOf(" + this.myMessage.getText() + ")");
                }
                String newText = "java.util.Objects.requireNonNull(" + this.myNullComparedExpression.getText() + messageText + ")";
                this.myReplacer.consume((Object)newText);
            }
        }
    }

    private static class IfToAssertionVisitor
    extends BaseInspectionVisitor {
        private IfToAssertionVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (statement.getCondition() != null && statement.getElseBranch() == null && IfCanBeAssertionInspection.getThrownNewException((PsiElement)statement.getThenBranch()) != null) {
                this.registerStatementError((PsiStatement)statement, PsiUtil.isLanguageLevel7OrHigher((PsiElement)statement) && ComparisonUtils.isNullComparison(statement.getCondition()), true);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (MethodCallUtils.isCallToMethod(expression2, IfCanBeAssertionInspection.GUAVA_PRECONDITIONS, null, IfCanBeAssertionInspection.GUAVA_CHECK_NON_NULL, (PsiType[])null) && expression2.getArgumentList().getExpressionCount() <= 2) {
                this.registerMethodCallError(expression2, PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2), false);
            }
        }
    }
}

