/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssignmentToSuperclassFieldInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assignment.to.superclass.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        PsiClass superclass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("assignment.to.superclass.field.problem.descriptor", referenceExpression.getReferenceName(), superclass.getName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToSuperclassFieldVisitor();
    }

    private static class AssignmentToSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private AssignmentToSuperclassFieldVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            this.checkSuperclassField(lhs);
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            this.checkSuperclassField(operand2);
        }

        private void checkSuperclassField(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression qualifierExpression2 = referenceExpression.getQualifierExpression();
            if (qualifierExpression2 != null && !(qualifierExpression2 instanceof PsiThisExpression) && !(qualifierExpression2 instanceof PsiSuperExpression)) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method == null || !method.isConstructor()) {
                return;
            }
            PsiClass assignmentClass = method.getContainingClass();
            String name = fieldClass.getQualifiedName();
            if (name == null || !InheritanceUtil.isInheritor((PsiClass)assignmentClass, (boolean)true, (String)name)) {
                return;
            }
            this.registerError((PsiElement)expression2, referenceExpression, fieldClass);
        }
    }
}

