/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayObjectsEqualsInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("array.objects.equals.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean deep = (Boolean)infos[0];
        return deep ? InspectionGadgetsBundle.message("array.objects.deep.equals.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("array.objects.equals.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean deep = (Boolean)infos[0];
        return new ArrayObjectsEqualsFix(deep);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayObjectsEqualsVisitor();
    }

    private static class ArrayObjectsEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayObjectsEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 2) {
                return;
            }
            PsiExpression argument1 = expressions2[0];
            PsiType type1 = argument1.getType();
            if (!(type1 instanceof PsiArrayType)) {
                return;
            }
            PsiExpression argument2 = expressions2[1];
            PsiType type2 = argument2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            int dimensions = type1.getArrayDimensions();
            if (dimensions != type2.getArrayDimensions()) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.util.Objects".equals(containingClass.getQualifiedName())) {
                return;
            }
            this.registerMethodCallError(expression2, dimensions > 1);
        }
    }

    private static class ArrayObjectsEqualsFix
    extends InspectionGadgetsFix {
        private final boolean myDeep;

        ArrayObjectsEqualsFix(boolean deep) {
            this.myDeep = deep;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myDeep ? InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]) : InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            StringBuilder newExpression = new StringBuilder("java.util.Arrays.");
            if (this.myDeep) {
                newExpression.append("deepEquals");
            } else {
                newExpression.append("equals");
            }
            CommentTracker commentTracker = new CommentTracker();
            newExpression.append(commentTracker.text((PsiElement)methodCallExpression.getArgumentList()));
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        }
    }
}

