/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssertWithSideEffectsInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assert.with.side.effects.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    private static boolean callHasSideEffects(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        if (JavaMethodContractUtil.isPure(method)) {
            return false;
        }
        MutationSignature signature = MutationSignature.fromMethod(method);
        if (signature.mutatesAnything()) {
            return signature.mutatedExpressions(call).anyMatch(expr -> !ExpressionUtils.isNewObject(expr));
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return false;
        }
        MethodSideEffectVisitor visitor = new MethodSideEffectVisitor();
        body2.accept((PsiElementVisitor)visitor);
        return visitor.hasSideEffects();
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private MethodSideEffectVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            this.checkExpression(expression2.getLExpression());
            super.visitAssignmentExpression(expression2);
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression2.getOperand());
            }
            super.visitUnaryExpression(expression2);
        }

        private void checkExpression(PsiExpression operand2) {
            if (!(operand2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiField) {
                this.hasSideEffects = true;
            }
        }

        private boolean hasSideEffects() {
            return this.hasSideEffects;
        }
    }

    private static class SideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private SideEffectVisitor() {
        }

        boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.hasSideEffects = true;
        }

        public void visitElement(PsiElement element) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (AssertWithSideEffectsInspection.callHasSideEffects(expression2)) {
                this.hasSideEffects = true;
            }
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            } else {
                super.visitUnaryExpression(expression2);
            }
        }
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression condition2 = statement.getAssertCondition();
            if (condition2 == null) {
                return;
            }
            SideEffectVisitor visitor = new SideEffectVisitor();
            condition2.accept((PsiElementVisitor)visitor);
            if (!visitor.hasSideEffects()) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

