/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class CastConflictsWithInstanceofInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.problem.descriptor", referenceExpression.getText());
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String castExpressionType = ((PsiTypeElement)infos[1]).getText();
        String instanceofType = ((PsiTypeElement)infos[2]).getText();
        return new InspectionGadgetsFix[]{new ReplaceCastFix(instanceofType, castExpressionType), new ReplaceInstanceofFix(instanceofType, castExpressionType)};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastConflictsWithInstanceofVisitor();
    }

    private static class ReplaceInstanceofFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        ReplaceInstanceofFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getFamilyName() {
            return "Replace instanceOf type";
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix2", this.myInstanceofType, this.myCastType);
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return instanceofTypeElement.replace((PsiElement)castTypeElement);
        }
    }

    private static class ReplaceCastFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        ReplaceCastFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix1", this.myCastType, this.myInstanceofType);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace cast type";
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return castTypeElement.replace((PsiElement)instanceofTypeElement);
        }
    }

    private static abstract class ReplaceFix
    extends InspectionGadgetsFix {
        protected ReplaceFix() {
        }

        @Override
        protected final void doFix(Project project, ProblemDescriptor descriptor) {
            PsiReferenceExpression reference;
            PsiTypeElement castTypeElement;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
                castTypeElement = typeCastExpression.getCastType();
                PsiExpression operand2 = typeCastExpression.getOperand();
                if (!(operand2 instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)operand2;
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
                castTypeElement = classObjectAccessExpression.getOperand();
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                if (!(argument instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)argument;
            } else {
                return;
            }
            if (castTypeElement == null) {
                return;
            }
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castTypeElement.getType(), reference, element);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            PsiElement newElement = this.replace(castTypeElement, instanceofTypeElement);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences(newElement);
        }

        protected abstract PsiElement replace(PsiTypeElement var1, PsiTypeElement var2);
    }

    private static class CastConflictsWithInstanceofVisitor
    extends BaseInspectionVisitor {
        private CastConflictsWithInstanceofVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiTypeElement castType = expression2.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type2 = castType.getType();
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(expression2.getOperand());
            if (!(operand2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(type2, referenceExpression, (PsiElement)expression2);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)expression2, referenceExpression, castType, instanceofTypeElement);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"cast".equals(methodName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Class".equals(qualifiedName)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
            PsiTypeElement operand2 = classObjectAccessExpression.getOperand();
            PsiType castType = operand2.getType();
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[0]);
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castType, referenceExpression, (PsiElement)expression2);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            this.registerError((PsiElement)expression2, referenceExpression, operand2, instanceofTypeElement);
        }
    }
}

