/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstantAssertConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.assert.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.assert.condition.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertConditionVisitor();
    }

    private static class ConstantAssertConditionVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertConditionVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression assertCondition = statement.getAssertCondition();
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(assertCondition);
            if (expression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(expression2)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

