/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteSideEffectsAwareFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = true;
    public boolean commentsAreContent = false;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        node.addContent(new Element("option").setAttribute("name", "m_reportEmptyBlocks").setAttribute("value", String.valueOf(this.m_reportEmptyBlocks)));
        if (this.commentsAreContent) {
            node.addContent(new Element("option").setAttribute("name", "commentsAreContent").setAttribute("value", "true"));
        }
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "StatementWithEmptyBody";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), "m_reportEmptyBlocks");
        panel.addCheckbox(InspectionGadgetsBundle.message("comments.as.content.option", new Object[0]), "commentsAreContent");
        return panel;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        LocalQuickFix fix2 = (LocalQuickFix)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])infos), LocalQuickFix.class);
        return fix2 == null ? null : new DelegatingFix(fix2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiStatement body2 = statement.getBody();
            if (body2 != null && this.isEmpty((PsiElement)body2)) {
                this.registerStatementError((PsiStatement)statement, this.createFix((PsiStatement)statement, statement.getIteratedValue()));
            }
        }

        private void checkLoopStatement(PsiLoopStatement statement) {
            PsiStatement body2 = statement.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            if (thenBranch != null && this.isEmpty((PsiElement)thenBranch)) {
                LocalQuickFix fix2 = elseBranch == null || this.isEmpty((PsiElement)elseBranch) ? this.createFix((PsiStatement)statement, statement.getCondition()) : null;
                this.registerStatementError((PsiStatement)statement, fix2);
                return;
            }
            if (elseBranch != null && this.isEmpty((PsiElement)elseBranch)) {
                PsiKeyword elseToken = statement.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[]{new DeleteElementFix((PsiElement)elseBranch)});
            }
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            PsiCodeBlock body2 = statement.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, this.createFix((PsiStatement)statement, statement.getExpression()));
        }

        @NotNull
        private LocalQuickFix createFix(@NotNull PsiStatement statement, PsiExpression expression2) {
            if (expression2 == null) {
                return new DeleteElementFix((PsiElement)statement);
            }
            return new DeleteSideEffectsAwareFix(statement, expression2);
        }

        private boolean isEmpty(PsiElement element) {
            return ControlFlowUtils.isEmpty(element, EmptyStatementBodyInspection.this.commentsAreContent, EmptyStatementBodyInspection.this.m_reportEmptyBlocks);
        }
    }
}

