/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.bugs.InconvertibleTypesChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    public boolean WARN_IF_NO_MUTUAL_SUBCLASS_FOUND = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.between.inconvertible.types.mutual.subclass.option", new Object[0]), (InspectionProfileEntry)this, "WARN_IF_NO_MUTUAL_SUBCLASS_FOUND");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        boolean convertible = (Boolean)infos[2];
        if (convertible) {
            return InspectionGadgetsBundle.message("equals.between.inconvertible.types.no.mutual.subclass.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        }
        return InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private class EqualsBetweenInconvertibleTypesVisitor
    extends BaseEqualsVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lhsType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rhsType) || !TypeUtils.areConvertible(lhsType, rhsType)) {
                return;
            }
            this.createInconvertibleTypesChecker().deepCheck(lhsType, rhsType, (PsiElement)expression2.getOperationSign(), new HashMap<PsiType, PsiType>(), EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND, this.isOnTheFly());
        }

        @Override
        public void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            this.createInconvertibleTypesChecker().checkTypes(expression2, leftType, rightType, EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND, this.isOnTheFly());
        }

        private InconvertibleTypesChecker createInconvertibleTypesChecker() {
            return new InconvertibleTypesChecker(){

                @Override
                protected void registerEqualsError(PsiElement highlightLocation, @NotNull PsiType leftType, @NotNull PsiType rightType, boolean convertible) {
                    EqualsBetweenInconvertibleTypesVisitor.this.registerError(highlightLocation, new Object[]{leftType, rightType, convertible});
                }
            };
        }
    }
}

