/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EqualsWhichDoesntCheckParameterClassInspection
extends BaseInspection {
    private static final CallMatcher REFLECTION_EQUALS = CallMatcher.staticCall("org.apache.commons.lang.builder.EqualsBuilder", "reflectionEquals");
    private static final CallMatcher CLASS_IS_INSTANCE = CallMatcher.instanceCall("java.lang.Class", "isInstance").parameterCount(1);
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWhichDoesntCheckParameterClassVisitor();
    }

    private static class ParameterClassCheckVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiParameter myParameter;
        private boolean myChecked;

        ParameterClassCheckVisitor(@NotNull PsiParameter parameter2) {
            this.myParameter = parameter2;
        }

        private void makeChecked() {
            this.myChecked = true;
            this.stopWalking();
        }

        @Contract(value="null -> false")
        private boolean isParameterReference(PsiExpression operand2) {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiParameter target = (PsiParameter)ObjectUtils.tryCast((Object)ref.resolve(), PsiParameter.class);
            if (target == this.myParameter) {
                return true;
            }
            if (target == null) {
                return false;
            }
            return target.getParent() instanceof PsiParameterList && target.getParent().getParent() instanceof PsiLambdaExpression;
        }

        private boolean isGetInstanceCall(PsiMethodCallExpression call) {
            if (!CLASS_IS_INSTANCE.test(call)) {
                return false;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            return this.isParameterReference(arg);
        }

        private boolean isGetClassCall(PsiMethodCallExpression call) {
            if (!OBJECT_GET_CLASS.test(call)) {
                return false;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return this.isParameterReference(qualifier);
        }

        private boolean isCallToSuperEquals(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!(qualifierExpression2 instanceof PsiSuperExpression)) {
                return false;
            }
            String name = methodExpression.getReferenceName();
            if (!"equals".equals(name)) {
                return false;
            }
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            return this.isParameterReference(arguments[0]);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (this.isGetClassCall(expression2) || this.isGetInstanceCall(expression2) || this.isCallToSuperEquals(expression2)) {
                this.makeChecked();
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (CLASS_IS_INSTANCE.methodReferenceMatches(expression2)) {
                this.makeChecked();
            }
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
            super.visitInstanceOfExpression(expression2);
            if (this.isParameterReference(expression2.getOperand())) {
                this.makeChecked();
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            if (!this.isParameterReference(operand2)) {
                return;
            }
            PsiTryStatement statement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTryStatement.class);
            if (statement == null) {
                return;
            }
            PsiParameter[] parameters2 = statement.getCatchBlockParameters();
            if (parameters2.length < 2) {
                return;
            }
            boolean nullPointerExceptionFound = false;
            boolean classCastExceptionFound = false;
            for (PsiParameter parameter2 : parameters2) {
                PsiType type2 = parameter2.getType();
                if (type2.equalsToText("java.lang.NullPointerException")) {
                    nullPointerExceptionFound = true;
                    if (!classCastExceptionFound) continue;
                    break;
                }
                if (!type2.equalsToText("java.lang.ClassCastException")) continue;
                classCastExceptionFound = true;
                if (nullPointerExceptionFound) break;
            }
            if (classCastExceptionFound && nullPointerExceptionFound) {
                this.makeChecked();
            }
        }

        public boolean isChecked() {
            return this.myChecked;
        }
    }

    private static class EqualsWhichDoesntCheckParameterClassVisitor
    extends BaseInspectionVisitor {
        private EqualsWhichDoesntCheckParameterClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!MethodUtils.isEquals(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter parameter2 = parameters2[0];
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null || EqualsWhichDoesntCheckParameterClassVisitor.isParameterChecked(body2, parameter2) || EqualsWhichDoesntCheckParameterClassVisitor.isParameterCheckNotNeeded(body2, parameter2)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isParameterChecked(PsiCodeBlock body2, PsiParameter parameter2) {
            ParameterClassCheckVisitor visitor = new ParameterClassCheckVisitor(parameter2);
            body2.accept((PsiElementVisitor)visitor);
            return visitor.isChecked();
        }

        private static boolean isParameterCheckNotNeeded(PsiCodeBlock body2, PsiParameter parameter2) {
            if (ControlFlowUtils.isEmptyCodeBlock(body2)) {
                return true;
            }
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body2);
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiReturnStatement)) {
                return true;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            Object constant = ExpressionUtils.computeConstantExpression(returnValue);
            if (Boolean.FALSE.equals(constant)) {
                return true;
            }
            if (REFLECTION_EQUALS.matches(returnValue)) {
                return true;
            }
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(returnValue, parameter2);
        }

        private static boolean isIdentityEquals(PsiExpression expression2, PsiParameter parameter2) {
            PsiExpression rhs;
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression lhs = binaryExpression.getLOperand();
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(lhs, rhs = binaryExpression.getROperand(), parameter2) || EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(rhs, lhs, parameter2);
        }

        private static boolean isIdentityEquals(PsiExpression lhs, PsiExpression rhs, PsiParameter parameter2) {
            return ExpressionUtils.isReferenceTo(lhs, (PsiVariable)parameter2) && rhs instanceof PsiThisExpression && ((PsiThisExpression)rhs).getQualifier() == null;
        }
    }
}

