/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;

public class InstantiationOfUtilityClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("instantiation.utility.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("instantiation.utility.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstantiationOfUtilityClassVisitor();
    }

    private static class InstantiationOfUtilityClassVisitor
    extends BaseInspectionVisitor {
        private InstantiationOfUtilityClassVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClass aClass = ((PsiClassType)type2).resolve();
            if (aClass == null) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

