/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class IteratorNextDoesNotThrowNoSuchElementExceptionInspection
extends BaseInspection {
    static final MethodMatcher methodMatcher = new MethodMatcher().add("java.util.Scanner", "next").add("java.util.StringTokenizer", "next(Element|Token)").add("java.util.Iterator", "next").add("java.util.ListIterator", "previous").add("java.util.Enumeration", "nextElement").add("java.util.PrimitiveIterator.OfInt", "nextInt").add("java.util.PrimitiveIterator.OfLong", "nextLong").add("java.util.PrimitiveIterator.OfDouble", "nextDouble");

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "IteratorNextCanNotThrowNoSuchElementException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IteratorNextDoesNotThrowNoSuchElementExceptionVisitor();
    }

    private static class CalledMethodsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean noSuchElementExceptionThrown;

        private CalledMethodsVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.noSuchElementExceptionThrown) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null || methodMatcher.matches(method)) {
                this.noSuchElementExceptionThrown = true;
                return;
            }
            if (method instanceof PsiCompiledElement) {
                return;
            }
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions((PsiElement)method);
            for (PsiType psiType : exceptions) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                this.noSuchElementExceptionThrown = true;
            }
        }

        boolean isNoSuchElementExceptionThrown() {
            return this.noSuchElementExceptionThrown;
        }
    }

    private static class IteratorNextDoesNotThrowNoSuchElementExceptionVisitor
    extends BaseInspectionVisitor {
        private IteratorNextDoesNotThrowNoSuchElementExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!MethodUtils.methodMatches(method, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            for (PsiType psiType : ExceptionUtil.getThrownExceptions((PsiElement)method)) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                return;
            }
            CalledMethodsVisitor visitor = new CalledMethodsVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.isNoSuchElementExceptionThrown()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

