/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.ThisPassedAsArgumentVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.awt.GridLayout;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedCollectionQueryUpdateInspection
extends BaseInspection {
    private static final CallMatcher TRANSFORMED = CallMatcher.staticCall("java.util.Collections", "asLifoQueue", "checkedCollection", "checkedList", "checkedMap", "checkedNavigableMap", "checkedNavigableSet", "checkedQueue", "checkedSet", "checkedSortedMap", "checkedSortedSet", "newSetFromMap", "synchronizedCollection", "synchronizedList", "synchronizedMap", "synchronizedNavigableMap", "synchronizedNavigableSet", "synchronizedSet", "synchronizedSortedMap", "synchronizedSortedSet");
    private static final CallMatcher DERIVED = CallMatcher.anyOf(CollectionUtils.DERIVED_COLLECTION, CallMatcher.instanceCall("java.util.List", "subList"), CallMatcher.instanceCall("java.util.SortedMap", "headMap", "tailMap", "subMap"), CallMatcher.instanceCall("java.util.SortedSet", "headSet", "tailSet", "subSet"));
    private static final CallMatcher COLLECTION_SAFE_ARGUMENT_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "addAll", "removeAll", "containsAll", "remove"), CallMatcher.instanceCall("java.util.Map", "putAll", "remove"));
    private static final Set<String> COLLECTIONS_QUERIES = ContainerUtil.set((Object[])new String[]{"binarySearch", "disjoint", "indexOfSubList", "lastIndexOfSubList", "max", "min"});
    private static final Set<String> COLLECTIONS_UPDATES = ContainerUtil.set((Object[])new String[]{"addAll", "fill", "copy", "replaceAll", "sort"});
    private static final Set<String> COLLECTIONS_ALL = StreamEx.of(COLLECTIONS_QUERIES).append(COLLECTIONS_UPDATES).toImmutableSet();
    public final ExternalizableStringSet queryNames = new ExternalizableStringSet("contains", "copyInto", "equals", "forEach", "get", "hashCode", "iterator", "parallelStream", "propertyNames", "replaceAll", "save", "size", "store", "stream", "toArray", "toString", "write");
    public final ExternalizableStringSet updateNames = new ExternalizableStringSet("add", "clear", "insert", "load", "merge", "offer", "poll", "pop", "push", "put", "remove", "replace", "retain", "set", "take");
    public final ExternalizableStringSet ignoredClasses = new ExternalizableStringSet(new String[0]);

    public JComponent createOptionsPanel() {
        ListTable queryNamesTable = new ListTable(new ListWrappingTableModel((List)((Object)this.queryNames), InspectionGadgetsBundle.message("query.column.name", new Object[0])));
        JPanel queryNamesPanel = UiUtils.createAddRemovePanel(queryNamesTable);
        ListTable updateNamesTable = new ListTable(new ListWrappingTableModel((List)((Object)this.updateNames), InspectionGadgetsBundle.message("update.column.name", new Object[0])));
        JPanel updateNamesPanel = UiUtils.createAddRemovePanel(updateNamesTable);
        String ignoreClassesMessage = InspectionGadgetsBundle.message("ignored.class.names", new Object[0]);
        ListTable ignoredClassesTable = new ListTable(new ListWrappingTableModel((List)((Object)this.ignoredClasses), ignoreClassesMessage));
        JPanel ignoredClassesPanel = UiUtils.createAddRemoveTreeClassChooserPanel(ignoredClassesTable, ignoreClassesMessage, "java.util.Collection", "java.util.Map");
        JPanel namesPanel = new JPanel(new GridLayout(1, 2, 10, 4));
        namesPanel.add(queryNamesPanel);
        namesPanel.add(updateNamesPanel);
        JPanel panel = new JPanel(new GridLayout(2, 1, 10, 4));
        panel.add(namesPanel);
        panel.add(ignoredClassesPanel);
        return panel;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        if (updated) {
            return InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
        }
        return InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    private QueryUpdateInfo getCollectionQueryUpdateInfo(final @Nullable PsiVariable variable, PsiElement context) {
        final QueryUpdateInfo info = new QueryUpdateInfo();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            public void visitReferenceExpression(PsiReferenceExpression ref) {
                super.visitReferenceExpression(ref);
                if (variable == null) {
                    if (ref.getQualifierExpression() == null) {
                        this.makeUpdated();
                        this.makeQueried();
                    }
                } else if (ref.isReferenceTo((PsiElement)variable)) {
                    this.process(this.findEffectiveReference((PsiExpression)ref));
                }
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                if (variable == null) {
                    this.process(this.findEffectiveReference((PsiExpression)expression2));
                }
            }

            private void makeUpdated() {
                info.updated = true;
                if (info.queried) {
                    this.stopWalking();
                }
            }

            private void makeQueried() {
                info.queried = true;
                if (info.updated) {
                    this.stopWalking();
                }
            }

            private void process(PsiExpression reference) {
                PsiExpressionList args;
                PsiCallExpression surroundingCall;
                PsiMethodCallExpression qualifiedCall = ExpressionUtils.getCallForQualifier(reference);
                if (qualifiedCall != null) {
                    this.processQualifiedCall(qualifiedCall);
                    return;
                }
                PsiElement parent = reference.getParent();
                if (parent instanceof PsiExpressionList && (surroundingCall = (PsiCallExpression)ObjectUtils.tryCast((Object)(args = (PsiExpressionList)parent).getParent(), PsiCallExpression.class)) != null) {
                    if (surroundingCall instanceof PsiMethodCallExpression && this.processCollectionMethods((PsiMethodCallExpression)surroundingCall, reference)) {
                        return;
                    }
                    this.makeQueried();
                    if (!MismatchedCollectionQueryUpdateInspection.isQueryMethod(surroundingCall) && !COLLECTION_SAFE_ARGUMENT_METHODS.matches((PsiExpression)surroundingCall)) {
                        this.makeUpdated();
                    }
                    return;
                }
                if (parent instanceof PsiMethodReferenceExpression) {
                    this.processQualifiedMethodReference((PsiMethodReferenceExpression)parent);
                    return;
                }
                if (parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == reference) {
                    this.makeQueried();
                    return;
                }
                if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == reference) {
                    PsiExpression rValue = ((PsiAssignmentExpression)parent).getRExpression();
                    if (rValue == null) {
                        return;
                    }
                    if (ExpressionUtils.nonStructuralChildren(rValue).allMatch(MismatchedCollectionQueryUpdateInspection::isEmptyCollectionInitializer)) {
                        return;
                    }
                    if (ExpressionUtils.nonStructuralChildren(rValue).allMatch(MismatchedCollectionQueryUpdateInspection::isCollectionInitializer)) {
                        this.makeUpdated();
                        return;
                    }
                }
                if (parent instanceof PsiPolyadicExpression) {
                    IElementType tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType();
                    if (tokenType.equals(JavaTokenType.PLUS)) {
                        this.makeQueried();
                        return;
                    }
                    if (tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE)) {
                        return;
                    }
                }
                if (parent instanceof PsiAssertStatement && ((PsiAssertStatement)parent).getAssertDescription() == reference) {
                    this.makeQueried();
                    return;
                }
                if (parent instanceof PsiInstanceOfExpression || parent instanceof PsiSynchronizedStatement) {
                    return;
                }
                this.makeUpdated();
                this.makeQueried();
            }

            private void processQualifiedMethodReference(PsiMethodReferenceExpression expression2) {
                PsiMethod method;
                String methodName = expression2.getReferenceName();
                if (MismatchedCollectionQueryUpdateInspection.this.isQueryMethodName(methodName)) {
                    this.makeQueried();
                }
                if (MismatchedCollectionQueryUpdateInspection.this.isUpdateMethodName(methodName)) {
                    this.makeUpdated();
                }
                if ((method = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class)) == null || PsiType.VOID.equals((Object)method.getReturnType()) || PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2))) {
                    return;
                }
                this.makeQueried();
            }

            private boolean processCollectionMethods(PsiMethodCallExpression call, PsiExpression arg) {
                PsiExpressionList expressionList = call.getArgumentList();
                String name = call.getMethodExpression().getReferenceName();
                if (!COLLECTIONS_ALL.contains(name) || !MismatchedCollectionQueryUpdateInspection.isCollectionsClassMethod(call)) {
                    return false;
                }
                if (COLLECTIONS_QUERIES.contains(name) && !(call.getParent() instanceof PsiExpressionStatement)) {
                    this.makeQueried();
                    return true;
                }
                if (COLLECTIONS_UPDATES.contains(name)) {
                    int index = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)arg);
                    if (index == 0) {
                        this.makeUpdated();
                    } else {
                        this.makeQueried();
                    }
                    return true;
                }
                return false;
            }

            private void processQualifiedCall(PsiMethodCallExpression call) {
                boolean voidContext = ExpressionUtils.isVoidContext((PsiExpression)call);
                String name = call.getMethodExpression().getReferenceName();
                boolean queryQualifier = MismatchedCollectionQueryUpdateInspection.this.isQueryMethodName(name);
                boolean updateQualifier = MismatchedCollectionQueryUpdateInspection.this.isUpdateMethodName(name);
                if (queryQualifier && (!voidContext || PsiType.VOID.equals((Object)call.getType()) || "toArray".equals(name) && !call.getArgumentList().isEmpty())) {
                    this.makeQueried();
                }
                if (updateQualifier) {
                    this.makeUpdated();
                    if (!voidContext) {
                        this.makeQueried();
                    }
                }
                if (!queryQualifier && !updateQualifier) {
                    if (!MismatchedCollectionQueryUpdateInspection.isQueryMethod((PsiCallExpression)call)) {
                        this.makeUpdated();
                    }
                    this.makeQueried();
                }
            }

            private PsiExpression findEffectiveReference(PsiExpression expression2) {
                while (true) {
                    PsiMethodCallExpression grandParent;
                    PsiElement parent;
                    if ((parent = expression2.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                        expression2 = (PsiExpression)parent;
                        continue;
                    }
                    if (parent instanceof PsiReferenceExpression) {
                        grandParent = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                        if (DERIVED.test(grandParent)) {
                            expression2 = grandParent;
                            continue;
                        }
                    }
                    if (!(parent instanceof PsiExpressionList)) break;
                    grandParent = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                    if (!TRANSFORMED.test(grandParent)) break;
                    expression2 = grandParent;
                }
                return expression2;
            }
        }
        Visitor visitor = new Visitor();
        context.accept((PsiElementVisitor)visitor);
        return info;
    }

    private boolean isQueryMethodName(String methodName) {
        return MismatchedCollectionQueryUpdateInspection.isQueryUpdateMethodName(methodName, (Set<String>)((Object)this.queryNames));
    }

    private boolean isUpdateMethodName(String methodName) {
        return MismatchedCollectionQueryUpdateInspection.isQueryUpdateMethodName(methodName, (Set<String>)((Object)this.updateNames));
    }

    static boolean isEmptyCollectionInitializer(PsiExpression initializer) {
        PsiExpression[] arguments;
        if (!(initializer instanceof PsiNewExpression)) {
            return ConstructionUtils.isEmptyCollectionInitializer(initializer);
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argumentType)) {
                return false;
            }
            if (!(argumentType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    static boolean isCollectionInitializer(PsiExpression initializer) {
        return MismatchedCollectionQueryUpdateInspection.isEmptyCollectionInitializer(initializer) || ConstructionUtils.isPrepopulatedCollectionInitializer(initializer);
    }

    private static boolean isQueryUpdateMethodName(String methodName, Set<String> myNames) {
        if (methodName == null) {
            return false;
        }
        if (myNames.contains(methodName)) {
            return true;
        }
        for (String updateName : myNames) {
            if (!methodName.startsWith(updateName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCollectionsClassMethod(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return "java.util.Collections".equals(qualifiedName);
    }

    private static boolean isQueryMethod(@NotNull PsiCallExpression call) {
        PsiType type2 = call.getType();
        boolean immutable = ClassUtils.isImmutable(type2);
        if (!immutable) {
            immutable = call instanceof PsiNewExpression && CollectionUtils.isConcreteCollectionClass(type2);
        }
        PsiMethod method = call.resolveMethod();
        if (!immutable && method != null) {
            PsiClass returnType = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
            if (returnType instanceof PsiTypeParameter) {
                boolean bl = immutable = ((PsiTypeParameter)returnType).getExtendsList().getReferencedTypes().length == 0;
            }
            if (!immutable) {
                immutable = Mutability.getMutability((PsiModifierListOwner)method).isUnmodifiable();
            }
        }
        return immutable && !SideEffectChecker.mayHaveSideEffects((PsiExpression)call);
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        private void register(PsiVariable variable, boolean written) {
            List expressions2;
            PsiExpression initializer;
            if (written && (initializer = variable.getInitializer()) != null && !(expressions2 = ExpressionUtils.nonStructuralChildren(initializer).collect(Collectors.toList())).stream().allMatch(MismatchedCollectionQueryUpdateInspection::isCollectionInitializer)) {
                expressions2.stream().filter(MismatchedCollectionQueryUpdateInspection::isCollectionInitializer).forEach(emptyCollection -> this.registerError((PsiElement)emptyCollection, Boolean.TRUE));
                return;
            }
            this.registerVariableError(variable, written);
        }

        public void visitField(@NotNull PsiField field) {
            boolean read2;
            PsiClass aClass;
            super.visitField(field);
            if (!(field.hasModifierProperty("private") || (aClass = field.getContainingClass()) != null && aClass.hasModifierProperty("private") && !field.hasModifierProperty("public"))) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!this.checkVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            QueryUpdateInfo info = MismatchedCollectionQueryUpdateInspection.this.getCollectionQueryUpdateInfo((PsiVariable)field, (PsiElement)containingClass);
            boolean written = info.updated || this.updatedViaInitializer((PsiVariable)field);
            boolean bl = read2 = info.queried || this.queriedViaInitializer((PsiVariable)field);
            if (read2 == written || UnusedSymbolUtil.isImplicitWrite((PsiVariable)field) || UnusedSymbolUtil.isImplicitRead((PsiVariable)field)) {
                return;
            }
            this.register((PsiVariable)field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean read2;
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!this.checkVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            QueryUpdateInfo info = MismatchedCollectionQueryUpdateInspection.this.getCollectionQueryUpdateInfo((PsiVariable)variable, (PsiElement)codeBlock);
            boolean written = info.updated || this.updatedViaInitializer((PsiVariable)variable);
            boolean bl = read2 = info.queried || this.queriedViaInitializer((PsiVariable)variable);
            if (read2 != written) {
                this.register((PsiVariable)variable, written);
            }
        }

        private boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type2 = variable.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type2)) {
                return false;
            }
            return MismatchedCollectionQueryUpdateInspection.this.ignoredClasses.stream().noneMatch(className -> InheritanceUtil.isInheritor((PsiType)type2, (String)className));
        }

        private boolean updatedViaInitializer(PsiVariable variable) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !ExpressionUtils.nonStructuralChildren(initializer).allMatch(MismatchedCollectionQueryUpdateInspection::isEmptyCollectionInitializer)) {
                return true;
            }
            if (initializer instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer).getAnonymousClass()) != null) {
                if (((MismatchedCollectionQueryUpdateInspection)MismatchedCollectionQueryUpdateInspection.this).getCollectionQueryUpdateInfo(null, (PsiElement)anonymousClass).updated) {
                    return true;
                }
                ThisPassedAsArgumentVisitor visitor = new ThisPassedAsArgumentVisitor();
                anonymousClass.accept((PsiElementVisitor)visitor);
                if (visitor.isPassed()) {
                    return true;
                }
            }
            return false;
        }

        private boolean queriedViaInitializer(PsiVariable variable) {
            PsiExpression initializer = variable.getInitializer();
            return initializer != null && ExpressionUtils.nonStructuralChildren(initializer).noneMatch(MismatchedCollectionQueryUpdateInspection::isCollectionInitializer);
        }
    }

    static class QueryUpdateInfo {
        boolean updated;
        boolean queried;

        QueryUpdateInfo() {
        }
    }
}

