/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualityInspection
extends BaseInspection {
    public boolean m_ignoreEnums = true;
    public boolean m_ignoreClassObjects = true;
    public boolean m_ignorePrivateConstructors = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("object.comparison.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("object.comparison.problem.description", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.enumerated.ignore.option", new Object[0]), "m_ignoreEnums");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.klass.ignore.option", new Object[0]), "m_ignoreClassObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.equality.ignore.between.objects.of.a.type.with.only.private.constructors.option", new Object[0]), "m_ignorePrivateConstructors");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    @NotNull
    public InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
    }

    private class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            ProblemHighlightType highlightType;
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (!this.isObjectType(rhs)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!this.isObjectType(lhs)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (MethodUtils.isEquals(method) && (this.isThisReference(lhs, method.getContainingClass()) || this.isThisReference(rhs, method.getContainingClass()))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreEnums && (TypeConversionUtil.isEnumType((PsiType)lhs.getType()) || TypeConversionUtil.isEnumType((PsiType)rhs.getType()))) {
                return;
            }
            if (this.shouldHighlight(expression2, rhs, lhs)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), highlightType, new Object[]{expression2});
        }

        private boolean shouldHighlight(@NotNull PsiBinaryExpression expression2, PsiExpression rhs, PsiExpression lhs) {
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)expression2.getOperationTokenType(), (PsiExpression)lhs, (PsiExpression)rhs, (boolean)false)) {
                return false;
            }
            if (ObjectEqualityInspection.this.m_ignoreClassObjects && (ClassUtils.isFinalClassWithDefaultEquals(PsiUtil.resolveClassInClassTypeOnly((PsiType)lhs.getType())) || ClassUtils.isFinalClassWithDefaultEquals(PsiUtil.resolveClassInClassTypeOnly((PsiType)rhs.getType())))) {
                return false;
            }
            return !ObjectEqualityInspection.this.m_ignorePrivateConstructors || !this.typeHasPrivateConstructor(lhs) && !this.typeHasPrivateConstructor(rhs);
        }

        private boolean typeHasPrivateConstructor(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            return aClass != null && aClass.isInterface() ? this.implementersHaveOnlyPrivateConstructors(aClass) : ClassUtils.hasOnlyPrivateConstructors(aClass);
        }

        private boolean implementersHaveOnlyPrivateConstructors(PsiClass aClass) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)aClass.getProject());
            PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(6);
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess(() -> ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor)), null);
            if (processor.isOverflow()) {
                return false;
            }
            Collection implementers = processor.getCollection();
            for (PsiClass implementer : implementers) {
                if (implementer.isInterface() || implementer.hasModifierProperty("abstract") || ClassUtils.hasOnlyPrivateConstructors(implementer)) continue;
                return false;
            }
            return true;
        }

        private boolean isObjectType(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            return type2 != null && !(type2 instanceof PsiArrayType) && !(type2 instanceof PsiPrimitiveType) && !TypeUtils.isJavaLangString(type2) && !TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Number");
        }

        private boolean isThisReference(@Nullable PsiExpression expression2, @Nullable PsiClass psiClass) {
            if (!(expression2 instanceof PsiThisExpression)) {
                return false;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)expression2;
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            return qualifier == null || psiClass != null && qualifier.isReferenceTo((PsiElement)psiClass);
        }
    }
}

