/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class StaticFieldReferenceOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "StaticFieldReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.field.via.subclass.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("static.field.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticFieldOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticFieldOnSubclassVisitor();
    }

    private static class StaticFieldOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticFieldOnSubclassVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement qualifier = expression2.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = expression2.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiElement qualifierReferent = ((PsiReferenceExpression)qualifier).resolve();
            if (!(qualifierReferent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)qualifierReferent;
            PsiClass declaringClass = field.getContainingClass();
            if (declaringClass == null || declaringClass.equals(referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)expression2, null)) {
                return;
            }
            PsiElement identifier = expression2.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, declaringClass, referencedClass);
        }
    }

    private static class StaticFieldOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticFieldOnSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("static.field.via.subclass.rationalize.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name = (PsiIdentifier)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiIdentifier.class);
            if (name == null) {
                return;
            }
            PsiReferenceExpression expression2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)name.getParent(), PsiReferenceExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiField field = (PsiField)ObjectUtils.tryCast((Object)expression2.resolve(), PsiField.class);
            if (field == null) {
                return;
            }
            PsiReplacementUtil.replaceExpressionWithReferenceTo((PsiExpression)expression2, (PsiMember)field);
        }
    }
}

