/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationMissingWhitespaceInspection
extends BaseInspection {
    public boolean ignoreNonStringLiterals = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonStringLiterals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationMissingWhitespaceVisitor();
    }

    private class StringConcatenationMissingWhitespaceVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationMissingWhitespaceVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType) || !ExpressionUtils.hasStringType((PsiExpression)expression2)) {
                return;
            }
            boolean formatCall = FormatUtils.isFormatCallArgument((PsiElement)expression2);
            PsiExpression[] operands2 = expression2.getOperands();
            PsiExpression lhs = operands2[0];
            for (int i = 1; i < operands2.length; ++i) {
                PsiJavaToken token;
                PsiExpression rhs = operands2[i];
                if (this.isMissingWhitespace(lhs, rhs, formatCall) && (token = expression2.getTokenBeforeOperand(rhs)) != null) {
                    this.registerError((PsiElement)token, new Object[0]);
                }
                lhs = rhs;
            }
        }

        private boolean isMissingWhitespace(PsiExpression lhs, PsiExpression rhs, boolean formatCall) {
            String rhsLiteral;
            char c;
            String lhsLiteral = this.computeStringValue(lhs);
            if (lhsLiteral != null) {
                int length = lhsLiteral.length();
                if (length == 0 || formatCall && lhsLiteral.endsWith("%n")) {
                    return false;
                }
                c = lhsLiteral.charAt(length - 1);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals && ExpressionUtils.hasStringType(lhs)) {
                return false;
            }
            if ((rhsLiteral = this.computeStringValue(rhs)) != null) {
                if (rhsLiteral.isEmpty() || formatCall && rhsLiteral.startsWith("%n")) {
                    return false;
                }
                c = rhsLiteral.charAt(0);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals && ExpressionUtils.hasStringType(rhs)) {
                return false;
            }
            return true;
        }

        @Nullable
        public String computeStringValue(@Nullable PsiExpression expression2) {
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            return value2 == null ? null : value2.toString();
        }
    }
}

