/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousSystemArraycopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("suspicious.system.arraycopy.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (String)infos[0];
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousSystemArraycopyVisitor();
    }

    private static class SuspiciousSystemArraycopyVisitor
    extends BaseInspectionVisitor {
        private SuspiciousSystemArraycopyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression dest;
            PsiType destType;
            PsiExpression src;
            PsiType srcType;
            PsiExpression length;
            PsiExpression destPos;
            super.visitMethodCallExpression(expression2);
            PsiClassType objectType = TypeUtils.getObjectType((PsiElement)expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.lang.System", (PsiType)PsiType.VOID, "arraycopy", new PsiType[]{objectType, PsiType.INT, objectType, PsiType.INT, PsiType.INT})) {
                return;
            }
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            if (arguments.length != 5) {
                return;
            }
            PsiExpression srcPos = arguments[1];
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(srcPos)) {
                this.registerError((PsiElement)srcPos, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor1", new Object[0]));
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(destPos = arguments[3])) {
                this.registerError((PsiElement)destPos, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor2", new Object[0]));
            }
            if (SuspiciousSystemArraycopyVisitor.isNegativeArgument(length = arguments[4])) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor3", new Object[0]));
            }
            if ((srcType = (src = arguments[0]).getType()) == null) {
                return;
            }
            boolean notArrayReported = false;
            if (!(srcType instanceof PsiArrayType)) {
                this.registerError((PsiElement)src, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor4", new Object[0]));
                notArrayReported = true;
            }
            if ((destType = (dest = arguments[2]).getType()) == null) {
                return;
            }
            if (!(destType instanceof PsiArrayType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor5", new Object[0]));
                notArrayReported = true;
            }
            if (notArrayReported) {
                return;
            }
            PsiArrayType srcArrayType = (PsiArrayType)srcType;
            PsiArrayType destArrayType = (PsiArrayType)destType;
            PsiType srcComponentType = srcArrayType.getComponentType();
            PsiType destComponentType = destArrayType.getComponentType();
            if (!(srcComponentType instanceof PsiPrimitiveType)) {
                if (!destComponentType.isAssignableFrom(srcComponentType)) {
                    this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
                }
            } else if (!destComponentType.equals(srcComponentType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
            }
        }

        private static boolean isNegativeArgument(@NotNull PsiExpression argument) {
            Object constant = ExpressionUtils.computeConstantExpression(argument);
            if (!(constant instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)constant;
            return integer < 0;
        }
    }
}

