/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThrowableNotThrownInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("throwable.not.thrown.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        if (expression2 instanceof PsiMethodCallExpression) {
            return InspectionGadgetsBundle.message("throwable.result.of.method.call.ignored.problem.descriptor", new Object[0]);
        }
        String type2 = TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.RuntimeException", "java.lang.Exception", "java.lang.Error");
        if ("java.lang.RuntimeException".equals(type2)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.runtime.exception.problem.descriptor", new Object[0]);
        }
        if ("java.lang.Exception".equals(type2)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.checked.exception.problem.descriptor", new Object[0]);
        }
        if ("java.lang.Error".equals(type2)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.error.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("throwable.instance.never.thrown.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowableResultOfMethodCallIgnoredVisitor();
    }

    static boolean isIgnoredThrowable(PsiExpression expression2) {
        if (!TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Throwable")) {
            return false;
        }
        return ThrowableNotThrownInspection.isIgnored(expression2, true);
    }

    private static boolean isIgnored(PsiExpression expression2, boolean checkDeep) {
        PsiElement parent = ThrowableNotThrownInspection.getHandlingParent(expression2);
        if (parent instanceof PsiVariable) {
            if (!(parent instanceof PsiLocalVariable)) {
                return false;
            }
            return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)parent);
        }
        if (parent instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)parent;
            PsiExpression expression1 = expressionStatement.getExpression();
            return !PsiType.VOID.equals((Object)expression1.getType());
        }
        if (parent instanceof PsiExpressionList) {
            return parent.getParent() instanceof PsiExpressionListStatement;
        }
        if (parent instanceof PsiLambdaExpression) {
            return PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)));
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiThrowStatement || parent instanceof PsiLoopStatement || parent instanceof PsiIfStatement || parent instanceof PsiAssertStatement) {
            return false;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)expression2, (boolean)false)) {
                return false;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable)) {
                return false;
            }
            return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)target);
        }
        return true;
    }

    private static PsiElement getHandlingParent(PsiExpression expression2) {
        PsiElement parent;
        while ((parent = ExpressionUtils.getPassThroughParent(expression2)) instanceof PsiExpression && !(parent instanceof PsiLambdaExpression) && !(parent instanceof PsiAssignmentExpression)) {
            expression2 = (PsiExpression)parent;
        }
        return parent;
    }

    private static boolean isUsedElsewhere(PsiLocalVariable variable) {
        Query query = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : query) {
            if (!(reference instanceof PsiReferenceExpression) || ThrowableNotThrownInspection.isIgnored((PsiExpression)reference, false)) continue;
            return true;
        }
        return false;
    }

    private static class ThrowableResultOfMethodCallIgnoredVisitor
    extends BaseInspectionVisitor {
        private ThrowableResultOfMethodCallIgnoredVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression2)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method.hasModifierProperty("static") && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.lang.Throwable")) {
                return;
            }
            StandardMethodContract contract = (StandardMethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodContracts(method));
            if (contract != null && contract.isTrivial() && contract.getReturnValue().isFail()) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }
}

