/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UseOfPropertiesAsHashtableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("properties.object.as.hashtable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("properties.object.as.hashtable.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression[] arguments;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        boolean put = "put".equals(methodName);
        if (!put && !"get".equals(methodName)) {
            return null;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType type2 = argument.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) continue;
            return null;
        }
        return new UseOfPropertiesAsHashtableFix(put);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfPropertiesAsHashtableVisitor();
    }

    private static class UseOfPropertiesAsHashtableVisitor
    extends BaseInspectionVisitor {
        private UseOfPropertiesAsHashtableVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "putAll".equals(methodName) || "get".equals(methodName))) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Hashtable")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Properties")) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }

    private static class UseOfPropertiesAsHashtableFix
    extends InspectionGadgetsFix {
        private final boolean put;

        UseOfPropertiesAsHashtableFix(boolean put) {
            this.put = put;
        }

        @NotNull
        public String getName() {
            if (this.put) {
                return InspectionGadgetsBundle.message("properties.object.as.hashtable.set.quickfix", new Object[0]);
            }
            return InspectionGadgetsBundle.message("properties.object.as.hashtable.get.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Fix property access";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null) {
                newExpression.append(commentTracker.text((PsiElement)qualifierExpression2));
                newExpression.append('.');
            }
            if (this.put) {
                newExpression.append("setProperty(");
            } else {
                newExpression.append("getProperty(");
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            newExpression.append(StringUtil.join((Object[])arguments, arg -> commentTracker.text((PsiElement)arg), (String)","));
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        }
    }
}

