/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameDiffersFromFileNameInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass[] classes2;
        PsiJavaFile file = (PsiJavaFile)infos[0];
        String fileName = file.getName();
        int prefixIndex = fileName.indexOf(46);
        String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
        for (PsiClass psiClass : classes2 = file.getClasses()) {
            String className = psiClass.getName();
            if (!filenameWithoutPrefix.equals(className)) continue;
            return null;
        }
        return new RenameFix(filenameWithoutPrefix);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.name.differs.from.file.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.name.differs.from.file.name.problem.descriptor", new Object[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameDiffersFromFileNameVisitor();
    }

    private static class ClassNameDiffersFromFileNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameDiffersFromFileNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)parent;
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String fileName = file.getName();
            int prefixIndex = fileName.indexOf(46);
            if (prefixIndex < 0) {
                return;
            }
            String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
            if (className.equals(filenameWithoutPrefix)) {
                return;
            }
            this.registerClassError(aClass, file);
        }
    }
}

