/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyClassInspection
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassWithParameterization;
    public boolean ignoreThrowables = true;
    public boolean commentsAreContent = true;

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 1;
        panel.add((Component)annotationsListControl, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("empty.class.ignore.parameterization.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassWithParameterization");
        panel.add((Component)checkBox1, constraints);
        ++constraints.gridy;
        CheckBox checkBox2 = new CheckBox("Ignore subclasses of java.lang.Throwable", (InspectionProfileEntry)this, "ignoreThrowables");
        panel.add((Component)checkBox2, constraints);
        ++constraints.gridy;
        CheckBox checkBox3 = new CheckBox(InspectionGadgetsBundle.message("comments.as.content.option", new Object[0]), (InspectionProfileEntry)this, "commentsAreContent");
        panel.add((Component)checkBox3, constraints);
        return panel;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "commentsAreContent");
        this.writeBooleanOption(node, "commentsAreContent", false);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("empty.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object element = infos[0];
        if (element instanceof PsiAnonymousClass) {
            return InspectionGadgetsBundle.message("empty.anonymous.class.problem.descriptor", new Object[0]);
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).isEnum() ? InspectionGadgetsBundle.message("empty.enum.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("empty.class.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("empty.class.file.without.class.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Object info = infos[0];
        if (!(info instanceof PsiModifierListOwner)) {
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        List<InspectionGadgetsFix> fixes = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)info, (List<String>)((Object)this.ignorableAnnotations), new ArrayList<InspectionGadgetsFix>());
        if (info instanceof PsiAnonymousClass) {
            fixes.add(0, new ConvertEmptyAnonymousToNewFix());
        }
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyClassVisitor();
    }

    private class EmptyClassVisitor
    extends BaseInspectionVisitor {
        private EmptyClassVisitor() {
        }

        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            if (javaFile.getClasses().length != 0) {
                return;
            }
            String fileName = javaFile.getName();
            if ("package-info.java".equals(fileName) || "module-info.java".equals(fileName)) {
                return;
            }
            this.registerError((PsiElement)file, file);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            super.visitClass(aClass);
            if (FileTypeUtils.isInServerPageFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract") && !aClass.isEnum()) {
                for (PsiClass superClass : aClass.getSupers()) {
                    if (!superClass.isInterface() && !superClass.hasModifierProperty("abstract")) continue;
                    return;
                }
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                return;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (EmptyClassInspection.this.commentsAreContent && PsiTreeUtil.getChildOfType((PsiElement)aClass, PsiComment.class) != null) {
                return;
            }
            if (EmptyClassInspection.this.ignoreClassWithParameterization && this.isSuperParametrization(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)EmptyClassInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            if (EmptyClassInspection.this.ignoreThrowables && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasTypeArguments(PsiReferenceList extendsList) {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (extendsList == null) {
                return false;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiType[] typeArguments;
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null || (typeArguments = parameterList.getTypeArguments()).length == 0) continue;
                return true;
            }
            return false;
        }

        private boolean isSuperParametrization(PsiClass aClass) {
            PsiTypeElement[] elements;
            if (!(aClass instanceof PsiAnonymousClass)) {
                PsiReferenceList extendsList = aClass.getExtendsList();
                PsiReferenceList implementsList = aClass.getImplementsList();
                return this.hasTypeArguments(extendsList) || this.hasTypeArguments(implementsList);
            }
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            PsiJavaCodeReferenceElement reference = anonymousClass.getBaseClassReference();
            PsiReferenceParameterList parameterList = reference.getParameterList();
            if (parameterList == null) {
                return false;
            }
            for (PsiTypeElement element : elements = parameterList.getTypeParameterElements()) {
                if (element == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class ConvertEmptyAnonymousToNewFix
    extends InspectionGadgetsFix {
        private ConvertEmptyAnonymousToNewFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiAnonymousClass)) {
                return;
            }
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            PsiElement lBrace = aClass.getLBrace();
            PsiElement rBrace = aClass.getRBrace();
            if (lBrace != null && rBrace != null) {
                PsiElement prev = lBrace.getPrevSibling();
                PsiElement start = prev instanceof PsiWhiteSpace ? prev : lBrace;
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(aClass.getContainingFile());
                if (document == null) {
                    return;
                }
                int anonymousStart = start.getTextRange().getStartOffset();
                int rBraceEnd = rBrace.getTextRange().getEndOffset();
                document.deleteString(anonymousStart, rBraceEnd);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Remove '{}'";
        }
    }
}

