/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public class FinalStaticMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("final.static.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("final.static.method.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalStaticMethodVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static class FinalStaticMethodVisitor
    extends BaseInspectionVisitor {
        private FinalStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.hasModifierProperty("final") || !method.hasModifierProperty("static")) {
                return;
            }
            if (HighlightUtil.isIllegalModifierCombination(method.getModifierList())) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)method, "final");
        }
    }
}

