/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MarkerInterfaceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("marker.interface.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("marker.interface.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MarkerInterfaceVisitor();
    }

    private static class MarkerInterfaceVisitor
    extends BaseInspectionVisitor {
        private MarkerInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length != 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length != 0) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && (referenceElements = extendsList.getReferenceElements()).length > 0) {
                if (referenceElements.length > 1) {
                    return;
                }
                PsiReferenceParameterList parameterList = referenceElements[0].getParameterList();
                if (parameterList == null) {
                    return;
                }
                PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
                if (typeParameterElements.length != 0) {
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

