/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectedMemberInFinalClassInspection
extends BaseInspection {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new RemoveModifierFix((String)infos[0]), new MakePrivateFix()};
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("protected.member.in.final.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("protected.member.in.final.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedMemberInFinalClassVisitor();
    }

    private static class ProtectedMemberInFinalClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedMemberInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)method, "protected");
        }

        public void visitField(@NotNull PsiField field) {
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)field, "protected");
        }
    }

    private static class MakePrivateFix
    extends InspectionGadgetsFix {
        private MakePrivateFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return currentFile;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("make.private.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            boolean conflictsDialogOK;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)grandParent;
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList == null) {
                return;
            }
            MultiMap conflicts = new MultiMap();
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                SuperMethodsSearch.search((PsiMethod)method, (PsiClass)method.getContainingClass(), (boolean)true, (boolean)false).forEach(methodSignature -> {
                    PsiMethod superMethod = methodSignature.getMethod();
                    conflicts.putValue((Object)superMethod, (Object)InspectionGadgetsBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)true)));
                    return true;
                });
                OverridingMethodsSearch.search((PsiMethod)method).forEach(overridingMethod -> {
                    conflicts.putValue(overridingMethod, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, (boolean)true)));
                    return false;
                });
            }
            PsiModifierList modifierListCopy = (PsiModifierList)modifierList.copy();
            modifierListCopy.setModifierProperty("private", true);
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope());
            search.forEach(reference -> {
                PsiElement element1 = reference.getElement();
                if (!JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierListCopy, element1, null, null)) {
                    PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element1, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                    assert (context != null);
                    conflicts.putValue((Object)element1, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), PsiBundle.visibilityPresentation((String)"private"), RefactoringUIUtil.getDescription((PsiElement)context, (boolean)true)}));
                }
                return true;
            });
            if (conflicts.isEmpty()) {
                conflictsDialogOK = true;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                ConflictsDialog conflictsDialog = new ConflictsDialog(member.getProject(), conflicts, () -> WriteAction.run(() -> modifierList.setModifierProperty("private", true)));
                conflictsDialogOK = conflictsDialog.showAndGet();
            }
            if (conflictsDialogOK) {
                WriteAction.run(() -> modifierList.setModifierProperty("private", true));
            }
        }
    }
}

