/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UtilityClassInspection
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    public JComponent createOptionsPanel() {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("utility.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("utility.class.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos[0], (List<String>)((Object)this.ignorableAnnotations));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassVisitor();
    }

    private class UtilityClassVisitor
    extends BaseInspectionVisitor {
        private UtilityClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)UtilityClassInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

