/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassComplexityInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COMPLEXITY_LIMIT = 80;

    @NotNull
    public String getID() {
        return "OverlyComplexClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overly.complex.class.display.name", new Object[0]);
    }

    @Override
    protected int getDefaultLimit() {
        return 80;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("cyclomatic.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer totalComplexity = (Integer)infos[0];
        return InspectionGadgetsBundle.message("overly.complex.class.problem.descriptor", totalComplexity);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassComplexityVisitor();
    }

    private class ClassComplexityVisitor
    extends BaseInspectionVisitor {
        private ClassComplexityVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int totalComplexity = this.calculateTotalComplexity(aClass);
            if (totalComplexity <= ClassComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalComplexity);
        }

        private int calculateTotalComplexity(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalComplexity = this.calculateComplexityForMethods(methods);
            return totalComplexity += this.calculateInitializerComplexity(aClass);
        }

        private int calculateInitializerComplexity(PsiClass aClass) {
            PsiClassInitializer[] initializers;
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                visitor.reset();
                initializer.accept((PsiElementVisitor)visitor);
                complexity += visitor.getComplexity();
            }
            return complexity;
        }

        private int calculateComplexityForMethods(PsiMethod[] methods) {
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiMethod method : methods) {
                visitor.reset();
                method.accept((PsiElementVisitor)visitor);
                complexity += visitor.getComplexity();
            }
            return complexity;
        }
    }
}

