/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_complexity = 1;

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        super.visitForStatement(statement);
        ++this.m_complexity;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        super.visitForeachStatement(statement);
        ++this.m_complexity;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        super.visitIfStatement(statement);
        ++this.m_complexity;
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        super.visitDoWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        super.visitConditionalExpression(expression2);
        ++this.m_complexity;
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        PsiCodeBlock body2 = statement.getBody();
        if (body2 == null) {
            return;
        }
        PsiStatement[] statements = body2.getStatements();
        boolean pendingLabel = false;
        for (PsiStatement child : statements) {
            if (child instanceof PsiSwitchLabelStatement) {
                if (!pendingLabel) {
                    ++this.m_complexity;
                }
                pendingLabel = true;
                continue;
            }
            pendingLabel = false;
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        super.visitWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        super.visitPolyadicExpression(expression2);
        IElementType token = expression2.getOperationTokenType();
        if (token.equals(JavaTokenType.ANDAND) || token.equals(JavaTokenType.OROR)) {
            this.m_complexity += expression2.getOperands().length - 1;
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        super.visitCatchSection(section);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }
}

