/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UseOfCloneInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("use.of.clone.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object errorElement = infos[0];
        if (errorElement instanceof PsiMethodCallExpression) {
            return InspectionGadgetsBundle.message("use.of.clone.call.problem.descriptor", new Object[0]);
        }
        if (errorElement instanceof PsiMethod) {
            return InspectionGadgetsBundle.message("use.of.clone.call.method.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("use.of.clone.reference.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfCloneVisitor();
    }

    private static class UseOfCloneVisitor
    extends BaseInspectionVisitor {
        private UseOfCloneVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiType type2;
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"clone".equals(referenceName) || !expression2.getArgumentList().isEmpty()) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null && (type2 = qualifierExpression2.getType()) instanceof PsiArrayType) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiMethod) || !CloneUtils.isClone((PsiMethod)target)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String qualifiedName = reference.getQualifiedName();
            if (!"java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        public void visitMethod(PsiMethod method) {
            if (!CloneUtils.isClone(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

