/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalExpressionInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(ConditionalExpressionInspection.class);
    public boolean ignoreSimpleAssignmentsAndReturns = false;
    public boolean ignoreExpressionContext = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("conditional.expression.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("conditional.expression.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.option", new Object[0]), "ignoreSimpleAssignmentsAndReturns");
        panel.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.expression.context.option", new Object[0]), "ignoreExpressionContext");
        return panel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean quickFix = (Boolean)infos[0];
        if (!quickFix) {
            return null;
        }
        boolean changesSemantics = (Boolean)infos[1];
        return new ReplaceWithIfFix(changesSemantics);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionVisitor();
    }

    private class ConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            boolean expressionContext;
            PsiTypeElement typeElement;
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)condition2);
            if (last instanceof PsiWhiteSpace) {
                last = last.getPrevSibling();
            }
            if (last instanceof PsiErrorElement) {
                return;
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiLocalVariable && (typeElement = ((PsiLocalVariable)parent).getTypeElement()).isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)typeElement.getType(), (PsiElement)typeElement)) {
                return;
            }
            boolean quickFixOnly = false;
            if (ConditionalExpressionInspection.this.ignoreSimpleAssignmentsAndReturns && (parent instanceof PsiAssignmentExpression || parent instanceof PsiReturnStatement || parent instanceof PsiLocalVariable || parent instanceof PsiLambdaExpression)) {
                quickFixOnly = true;
            }
            if ((expressionContext = this.isExpressionContext(expression2)) && (ConditionalExpressionInspection.this.ignoreExpressionContext || !this.isVisibleHighlight((PsiElement)expression2))) {
                return;
            }
            boolean nestedConditional = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2) instanceof PsiConditionalExpression;
            if ((quickFixOnly |= nestedConditional) && !this.isOnTheFly()) {
                return;
            }
            this.registerError((PsiElement)expression2, quickFixOnly ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{!expressionContext, nestedConditional});
        }

        private boolean isExpressionContext(PsiConditionalExpression expression2) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class);
            if (member instanceof PsiField) {
                return true;
            }
            if (!(member instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)member;
            if (!method.isConstructor()) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiStatement.class, PsiMember.class});
            return JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCallExpression);
        }
    }

    private static class ReplaceWithIfFix
    extends InspectionGadgetsFix {
        private final boolean myChangesSemantics;

        ReplaceWithIfFix(boolean changesSemantics) {
            this.myChangesSemantics = changesSemantics;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.myChangesSemantics ? InspectionGadgetsBundle.message("conditional.expression.semantics.quickfix", new Object[0]) : InspectionGadgetsBundle.message("conditional.expression.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement statement;
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
            if (!PsiTreeUtil.processElements((PsiElement)expression2, e -> !(e instanceof PsiErrorElement))) {
                return;
            }
            PsiElement expressionParent = expression2.getParent();
            if (expressionParent instanceof PsiLambdaExpression) {
                PsiCodeBlock codeBlock = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)expressionParent);
                PsiStatement statement2 = codeBlock.getStatements()[0];
                if (statement2 instanceof PsiReturnStatement) {
                    PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                    expression2 = (PsiConditionalExpression)returnStatement.getReturnValue();
                } else {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                    expression2 = (PsiConditionalExpression)expressionStatement.getExpression();
                }
            }
            if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class)) == null) {
                return;
            }
            if (statement instanceof PsiExpressionStatement && statement.getParent() instanceof PsiSwitchLabeledRuleStatement) {
                expression2 = RefactoringUtil.ensureCodeBlock(expression2);
                LOG.assertTrue(expression2 != null);
                statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            }
            PsiVariable variable = statement instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiVariable.class) : null;
            PsiExpression thenExpression2 = ParenthesesUtils.stripParentheses(expression2.getThenExpression());
            PsiExpression elseExpression2 = ParenthesesUtils.stripParentheses(expression2.getElseExpression());
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(expression2.getCondition());
            CommentTracker tracker = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            newStatement.append("if(");
            if (condition2 != null) {
                newStatement.append(tracker.text((PsiElement)condition2));
            }
            newStatement.append(')');
            if (variable != null) {
                int conditionIdx;
                String name = variable.getName();
                newStatement.append(name).append('=');
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement != null && typeElement.isInferredType() && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement) == null) {
                    return;
                }
                if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression2)) >= 0) {
                    initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType()));
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                    LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                    expression2 = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                    thenExpression2 = expression2.getThenExpression();
                    elseExpression2 = expression2.getElseExpression();
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, thenExpression2, newStatement, tracker);
                newStatement.append("; else ").append(name).append('=');
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, elseExpression2, newStatement, tracker);
                newStatement.append(';');
                tracker.delete((PsiElement)initializer);
                PsiManager manager = statement.getManager();
                PsiStatement ifStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(newStatement.toString(), (PsiElement)statement);
                PsiElement parent = statement.getParent();
                PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement);
                tracker.insertCommentsBefore(addedElement);
                CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                styleManager.reformat(addedElement);
            } else {
                boolean addBraces;
                boolean bl = addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
                if (addBraces || thenExpression2 == null) {
                    newStatement.append('{');
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)statement, (PsiExpression)expression2, thenExpression2, newStatement, tracker);
                if (addBraces) {
                    newStatement.append("} else {");
                } else {
                    if (thenExpression2 == null) {
                        newStatement.append('}');
                    }
                    newStatement.append(" else ");
                    if (elseExpression2 == null) {
                        newStatement.append('{');
                    }
                }
                ReplaceWithIfFix.appendElementTextWithoutParentheses((PsiElement)statement, (PsiExpression)expression2, elseExpression2, newStatement, tracker);
                if (addBraces || elseExpression2 == null) {
                    newStatement.append('}');
                }
                PsiReplacementUtil.replaceStatement(statement, newStatement.toString(), tracker);
            }
        }

        private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiExpression expressionToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out, CommentTracker tracker) {
            PsiElement expressionParent = expressionToReplace.getParent();
            if (expressionParent instanceof PsiParenthesizedExpression) {
                PsiElement grandParent = expressionParent.getParent();
                if (replacementExpression == null || !(grandParent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(replacementExpression, (PsiExpression)grandParent, false)) {
                    ReplaceWithIfFix.appendElementTextWithoutParentheses(element, (PsiExpression)expressionParent, replacementExpression, out, tracker);
                    return;
                }
            }
            boolean needsCast = replacementExpression != null && MethodCallUtils.isNecessaryForSurroundingMethodCall(expressionToReplace, replacementExpression);
            ReplaceWithIfFix.appendElementText(element, expressionToReplace, replacementExpression, needsCast, out, tracker);
        }

        private static void appendElementText(@NotNull PsiElement element, @NotNull PsiExpression elementToReplace, @Nullable PsiExpression replacementExpression, boolean insertCast, @NotNull StringBuilder out, CommentTracker tracker) {
            if (element.equals(elementToReplace)) {
                String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
                PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)ExpectedTypeUtils.findExpectedType(elementToReplace, true));
                if (insertCast && type2 != null) {
                    out.append('(').append(type2.getCanonicalText()).append(')');
                }
                out.append(replacementText);
                return;
            }
            PsiElement[] children = element.getChildren();
            if (children.length == 0 && !(element instanceof PsiComment)) {
                out.append(tracker.text(element));
            }
            for (PsiElement child : children) {
                ReplaceWithIfFix.appendElementText(child, elementToReplace, replacementExpression, insertCast, out, tracker);
            }
        }
    }
}

