/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isUnaryNegation((PsiPrefixExpression)expression2);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isBinaryNegation((PsiPolyadicExpression)expression2);
        }
        return false;
    }

    static boolean isUnaryNegation(PsiPrefixExpression expression2) {
        return JavaTokenType.EXCL.equals(expression2.getOperationTokenType());
    }

    static boolean isBinaryNegation(PsiPolyadicExpression expression2) {
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length == 1) {
            return false;
        }
        for (PsiExpression operand2 : operands2) {
            if (!TypeUtils.hasFloatingPointType(operand2)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression2.getOperationTokenType());
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            PsiExpression nestedPrefixOperand;
            super.visitPrefixExpression(expression2);
            if (!DoubleNegationInspection.isUnaryNegation(expression2)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (!DoubleNegationInspection.isNegation(operand2)) {
                return;
            }
            PsiExpression nestedOperand = ParenthesesUtils.stripParentheses(operand2);
            if (nestedOperand instanceof PsiPrefixExpression && ((nestedPrefixOperand = ((PsiPrefixExpression)nestedOperand).getOperand()) == null || !LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)expression2, (PsiExpression)nestedPrefixOperand))) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            if (!DoubleNegationInspection.isBinaryNegation(expression2)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand2 : operands2) {
                    if (DoubleNegationInspection.isNegation(operand2)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement expression2 = descriptor.getPsiElement();
            CommentTracker tracker = new CommentTracker();
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiExpression operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, BoolUtils.getNegatedExpressionText(operand2, tracker), tracker);
            } else if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands2 = polyadicExpression.getOperands();
                int length = operands2.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands2[0];
                    PsiExpression secondOperand = operands2[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand, tracker) + "==" + tracker.text((PsiElement)secondOperand), tracker);
                    } else {
                        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, tracker.text((PsiElement)firstOperand) + "==" + BoolUtils.getNegatedExpressionText(secondOperand, tracker), tracker);
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            if (length % 2 != 1 && i == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(tracker.text((PsiElement)operands2[i]));
                    }
                    PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString(), tracker);
                }
            }
        }
    }
}

