/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallthruInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("fallthru.in.switch.statement.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "fallthrough";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("fallthru.in.switch.statement.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return (Boolean)infos[0] != false ? new FallthruInSwitchStatementFix() : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FallthroughInSwitchStatementVisitor();
    }

    private static class FallthroughInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*-?thro?u");

        private FallthroughInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            this.doCheckSwitchBlock((PsiSwitchBlock)switchStatement);
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.doCheckSwitchBlock((PsiSwitchBlock)expression2);
        }

        private void doCheckSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
            PsiCodeBlock body2 = switchBlock.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            for (int i = 1; i < statements.length; ++i) {
                PsiStatement previousStatement;
                PsiComment comment;
                String commentText;
                PsiStatement statement = statements[i];
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    return;
                }
                PsiElement previousSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
                if (previousSibling instanceof PsiComment && commentPattern.matcher(commentText = (comment = (PsiComment)previousSibling).getText()).find() && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment) == null || (previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class)) instanceof PsiSwitchLabelStatement || !ControlFlowUtils.statementMayCompleteNormally(previousStatement)) continue;
                this.registerError((PsiElement)statement, switchBlock instanceof PsiSwitchStatement || this.isOnTheFly());
            }
        }
    }

    private static class FallthruInSwitchStatementFix
    extends InspectionGadgetsFix {
        private FallthruInSwitchStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("fallthru.in.switch.statement.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)descriptor.getPsiElement();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiSwitchBlock switchBlock = labelStatement.getEnclosingSwitchBlock();
            String value2 = "";
            if (switchBlock instanceof PsiSwitchExpression) {
                value2 = " " + PsiTypesUtil.getDefaultValueOfType((PsiType)((PsiSwitchExpression)switchBlock).getType()) + " ";
            }
            PsiStatement breakStatement = factory.createStatementFromText("break" + value2 + ";", (PsiElement)labelStatement);
            PsiElement parent = labelStatement.getParent();
            parent.addBefore((PsiElement)breakStatement, (PsiElement)labelStatement);
        }
    }
}

