/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfMayBeConditionalInspection
extends BaseInspection {
    public boolean reportMethodCalls = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("if.may.be.conditional.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("if.may.be.conditional.report.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "reportMethodCalls");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfMayBeConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfMayBeConditionalVisitor();
    }

    private class IfMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private IfMayBeConditionalVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (ControlFlowUtils.isElseIf(statement)) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(thenBranch);
            if (thenStatement == null) {
                return;
            }
            PsiStatement elseStatement = ControlFlowUtils.stripBraces(elseBranch);
            if (elseStatement == null) {
                return;
            }
            if (thenStatement instanceof PsiReturnStatement) {
                if (!(elseStatement instanceof PsiReturnStatement)) {
                    return;
                }
                PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenStatement;
                PsiExpression thenReturnValue = ParenthesesUtils.stripParentheses(thenReturnStatement.getReturnValue());
                if (thenReturnValue instanceof PsiConditionalExpression) {
                    return;
                }
                PsiReturnStatement elseReturnStatement = (PsiReturnStatement)elseStatement;
                PsiExpression elseReturnValue = ParenthesesUtils.stripParentheses(elseReturnStatement.getReturnValue());
                if (elseReturnValue instanceof PsiConditionalExpression) {
                    return;
                }
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            } else if (thenStatement instanceof PsiExpressionStatement) {
                if (!(elseStatement instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenStatement;
                PsiExpression thenExpression2 = thenExpressionStatement.getExpression();
                PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseStatement;
                PsiExpression elseExpression2 = elseExpressionStatement.getExpression();
                if (thenExpression2 instanceof PsiAssignmentExpression) {
                    if (!(elseExpression2 instanceof PsiAssignmentExpression)) {
                        return;
                    }
                    PsiAssignmentExpression thenAssignmentExpression = (PsiAssignmentExpression)thenExpression2;
                    PsiAssignmentExpression elseAssignmentExpression = (PsiAssignmentExpression)elseExpression2;
                    if (!thenAssignmentExpression.getOperationTokenType().equals(elseAssignmentExpression.getOperationTokenType())) {
                        return;
                    }
                    PsiExpression thenLhs = thenAssignmentExpression.getLExpression();
                    PsiExpression elseLhs = elseAssignmentExpression.getLExpression();
                    if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs)) {
                        return;
                    }
                    PsiExpression thenRhs = ParenthesesUtils.stripParentheses(thenAssignmentExpression.getRExpression());
                    if (thenRhs instanceof PsiConditionalExpression) {
                        return;
                    }
                    PsiExpression elseRhs = ParenthesesUtils.stripParentheses(elseAssignmentExpression.getRExpression());
                    if (elseRhs instanceof PsiConditionalExpression) {
                        return;
                    }
                    this.registerStatementError((PsiStatement)statement, new Object[0]);
                } else if (IfMayBeConditionalInspection.this.reportMethodCalls && thenExpression2 instanceof PsiMethodCallExpression) {
                    PsiExpressionList elseArgumentList;
                    PsiExpression[] elseArguments;
                    if (!(elseExpression2 instanceof PsiMethodCallExpression)) {
                        return;
                    }
                    PsiMethodCallExpression thenMethodCallExpression = (PsiMethodCallExpression)thenExpression2;
                    PsiMethodCallExpression elseMethodCallExpression = (PsiMethodCallExpression)elseExpression2;
                    PsiReferenceExpression thenMethodExpression = thenMethodCallExpression.getMethodExpression();
                    PsiReferenceExpression elseMethodExpression = elseMethodCallExpression.getMethodExpression();
                    if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)thenMethodExpression, (PsiExpression)elseMethodExpression)) {
                        return;
                    }
                    PsiExpressionList thenArgumentList = thenMethodCallExpression.getArgumentList();
                    PsiExpression[] thenArguments = thenArgumentList.getExpressions();
                    if (thenArguments.length != (elseArguments = (elseArgumentList = elseMethodCallExpression.getArgumentList()).getExpressions()).length) {
                        return;
                    }
                    int differences = 0;
                    int length = thenArguments.length;
                    for (int i = 0; i < length; ++i) {
                        PsiExpression thenArgument = thenArguments[i];
                        PsiExpression elseArgument = elseArguments[i];
                        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) continue;
                        ++differences;
                    }
                    if (differences == 1) {
                        this.registerStatementError((PsiStatement)statement, new Object[0]);
                    }
                }
            }
        }
    }

    private static class IfMayBeConditionalFix
    extends InspectionGadgetsFix {
        private IfMayBeConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiStatement elseStatement = ControlFlowUtils.stripBraces(elseBranch);
            PsiExpression condition2 = ifStatement.getCondition();
            CommentTracker tracker = new CommentTracker();
            StringBuilder replacementText = new StringBuilder();
            if (thenStatement instanceof PsiReturnStatement) {
                PsiReturnStatement elseReturn = (PsiReturnStatement)elseStatement;
                PsiReturnStatement thenReturn = (PsiReturnStatement)thenStatement;
                replacementText.append("return ");
                IfMayBeConditionalFix.appendExpressionText(condition2, replacementText, tracker);
                replacementText.append('?');
                PsiExpression thenReturnValue = thenReturn.getReturnValue();
                IfMayBeConditionalFix.appendExpressionText(thenReturnValue, replacementText, tracker);
                replacementText.append(':');
                if (elseReturn != null) {
                    PsiExpression elseReturnValue = elseReturn.getReturnValue();
                    IfMayBeConditionalFix.appendExpressionText(elseReturnValue, replacementText, tracker);
                }
                replacementText.append(';');
            } else if (thenStatement instanceof PsiExpressionStatement && elseStatement instanceof PsiExpressionStatement) {
                PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenStatement;
                PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseStatement;
                PsiExpression thenExpression2 = thenExpressionStatement.getExpression();
                PsiExpression elseExpression2 = elseExpressionStatement.getExpression();
                if (thenExpression2 instanceof PsiAssignmentExpression && elseExpression2 instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression thenAssignmentExpression = (PsiAssignmentExpression)thenExpression2;
                    PsiExpression lhs = thenAssignmentExpression.getLExpression();
                    replacementText.append(tracker.text((PsiElement)lhs));
                    PsiJavaToken token = thenAssignmentExpression.getOperationSign();
                    replacementText.append(token.getText());
                    IfMayBeConditionalFix.appendExpressionText(condition2, replacementText, tracker);
                    replacementText.append('?');
                    PsiExpression thenRhs = thenAssignmentExpression.getRExpression();
                    IfMayBeConditionalFix.appendExpressionText(thenRhs, replacementText, tracker);
                    replacementText.append(':');
                    PsiAssignmentExpression elseAssignmentExpression = (PsiAssignmentExpression)elseExpression2;
                    PsiExpression elseRhs = elseAssignmentExpression.getRExpression();
                    IfMayBeConditionalFix.appendExpressionText(elseRhs, replacementText, tracker);
                    replacementText.append(';');
                } else if (thenExpression2 instanceof PsiMethodCallExpression && elseExpression2 instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression thenMethodCallExpression = (PsiMethodCallExpression)thenExpression2;
                    PsiMethodCallExpression elseMethodCallExpression = (PsiMethodCallExpression)elseExpression2;
                    PsiReferenceExpression thenMethodExpression = thenMethodCallExpression.getMethodExpression();
                    replacementText.append(tracker.text((PsiElement)thenMethodExpression));
                    replacementText.append('(');
                    PsiExpressionList thenArgumentList = thenMethodCallExpression.getArgumentList();
                    PsiExpression[] thenArguments = thenArgumentList.getExpressions();
                    PsiExpressionList elseArgumentList = elseMethodCallExpression.getArgumentList();
                    PsiExpression[] elseArguments = elseArgumentList.getExpressions();
                    int length = thenArguments.length;
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            replacementText.append(',');
                        }
                        PsiExpression thenArgument = thenArguments[i];
                        PsiExpression elseArgument = elseArguments[i];
                        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) {
                            replacementText.append(tracker.text((PsiElement)thenArgument));
                            continue;
                        }
                        IfMayBeConditionalFix.appendExpressionText(condition2, replacementText, tracker);
                        replacementText.append('?');
                        IfMayBeConditionalFix.appendExpressionText(thenArgument, replacementText, tracker);
                        replacementText.append(':');
                        IfMayBeConditionalFix.appendExpressionText(elseArgument, replacementText, tracker);
                    }
                    replacementText.append(");");
                } else {
                    return;
                }
            }
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, replacementText.toString(), tracker);
        }

        private static void appendExpressionText(@Nullable PsiExpression expression2, StringBuilder out, CommentTracker tracker) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return;
            }
            out.append(tracker.text(expression2, 15));
        }
    }
}

