/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class LoopStatementsThatDontLoopInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "LoopStatementThatDoesntLoop";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("loop.statements.that.dont.loop.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("loop.statements.that.dont.loop.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopStatementsThatDontLoopVisitor();
    }

    private static class LoopStatementsThatDontLoopVisitor
    extends BaseInspectionVisitor {
        private LoopStatementsThatDontLoopVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

