/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopWithImplicitTerminationConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.dowhile.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoopWithImplicitTerminationConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopWithImplicitTerminationConditionVisitor();
    }

    static boolean containsUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBlockStatement)) {
            return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(statement);
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(firstStatement);
    }

    private static boolean isUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBreakStatement)) {
            return false;
        }
        PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
        PsiIdentifier identifier = breakStatement.getLabelIdentifier();
        return identifier == null;
    }

    private static class LoopWithImplicitTerminationConditionVisitor
    extends BaseInspectionVisitor {
        private LoopWithImplicitTerminationConditionVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (!BoolUtils.isTrue(condition2)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, Boolean.FALSE);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (!BoolUtils.isTrue(condition2)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement, false)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, Boolean.TRUE);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (!BoolUtils.isTrue(condition2)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, Boolean.FALSE);
        }

        private static boolean isLoopWithImplicitTerminationCondition(PsiLoopStatement statement, boolean firstStatement) {
            PsiStatement bodyStatement;
            PsiStatement body2 = statement.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                bodyStatement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                bodyStatement = body2;
            }
            return !LoopWithImplicitTerminationConditionVisitor.isImplicitTerminationCondition(bodyStatement);
        }

        private static boolean isImplicitTerminationCondition(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch);
        }
    }

    private static class LoopWithImplicitTerminationConditionFix
    extends InspectionGadgetsFix {
        private LoopWithImplicitTerminationConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement statement;
            boolean firstStatement;
            PsiStatement body2;
            PsiExpression loopCondition;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
                loopCondition = whileStatement.getCondition();
                body2 = whileStatement.getBody();
                firstStatement = true;
            } else if (parent instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)parent;
                loopCondition = doWhileStatement.getCondition();
                body2 = doWhileStatement.getBody();
                firstStatement = false;
            } else if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                loopCondition = forStatement.getCondition();
                body2 = forStatement.getBody();
                firstStatement = true;
            } else {
                return;
            }
            if (loopCondition == null) {
                return;
            }
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return;
                }
                statement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                statement = body2;
            }
            if (!(statement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression ifCondition = ifStatement.getCondition();
            if (ifCondition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                CommentTracker commentTracker = new CommentTracker();
                String negatedExpressionText = BoolUtils.getNegatedExpressionText(ifCondition, commentTracker);
                PsiReplacementUtil.replaceExpression(loopCondition, negatedExpressionText, commentTracker);
                LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, elseBranch);
            } else if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch)) {
                loopCondition.replace((PsiElement)ifCondition);
                if (thenBranch == null) {
                    ifStatement.delete();
                } else {
                    LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, thenBranch);
                }
            }
        }

        private static void replaceStatement(@NotNull PsiStatement replacedStatement, @Nullable PsiStatement replacingStatement) {
            if (replacingStatement == null) {
                replacedStatement.delete();
                return;
            }
            if (!(replacingStatement instanceof PsiBlockStatement)) {
                replacedStatement.replace((PsiElement)replacingStatement);
                return;
            }
            PsiBlockStatement blockStatement = (PsiBlockStatement)replacingStatement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                PsiElement receiver2 = replacedStatement.getParent();
                for (int i = children.length - 2; i > 0; --i) {
                    PsiElement child = children[i];
                    if (child instanceof PsiWhiteSpace) continue;
                    receiver2.addAfter(child, (PsiElement)replacedStatement);
                }
                replacedStatement.delete();
            }
        }
    }
}

