/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NegatedConditionalInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;
    public boolean m_ignoreNegatedZeroComparison = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("negated.conditional.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "ConditionalExpressionWithNegatedCondition";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("negated.conditional.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalVisitor();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.null.option", new Object[0]), "m_ignoreNegatedNullComparison");
        panel.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.zero.option", new Object[0]), "m_ignoreNegatedZeroComparison");
        return panel;
    }

    public void writeSettings(@NotNull Element node) {
        this.defaultWriteSettings(node, "m_ignoreNegatedZeroComparison");
        this.writeBooleanOption(node, "m_ignoreNegatedZeroComparison", true);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedConditionalFix();
    }

    private class NegatedConditionalVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenBranch = expression2.getThenExpression();
            if (thenBranch == null) {
                return;
            }
            PsiExpression elseBranch = expression2.getElseExpression();
            if (elseBranch == null) {
                return;
            }
            PsiExpression condition2 = expression2.getCondition();
            if (!ExpressionUtils.isNegation(condition2, NegatedConditionalInspection.this.m_ignoreNegatedNullComparison, NegatedConditionalInspection.this.m_ignoreNegatedZeroComparison)) {
                return;
            }
            this.registerError((PsiElement)condition2, new Object[0]);
        }
    }

    private static class NegatedConditionalFix
    extends InspectionGadgetsFix {
        private NegatedConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("negated.conditional.invert.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element.getParent();
            assert (conditionalExpression != null);
            PsiExpression elseBranch = conditionalExpression.getElseExpression();
            PsiExpression thenBranch = conditionalExpression.getThenExpression();
            PsiExpression condition2 = conditionalExpression.getCondition();
            CommentTracker tracker = new CommentTracker();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition2, tracker);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + '?' + tracker.text((PsiElement)elseBranch) + ':' + tracker.text((PsiElement)thenBranch);
            PsiReplacementUtil.replaceExpression((PsiExpression)conditionalExpression, newStatement);
        }
    }
}

