/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 10;
    public int m_limit = 10;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("switch.statement.with.too.many.branches.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("if.statement.with.too.many.branches.max.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("if.statement.with.too.many.branches.problem.descriptor", branchCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooManyBranchesVisitor();
    }

    private class SwitchStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooManyBranchesVisitor() {
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            this.processSwitch((PsiSwitchBlock)expression2);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            this.processSwitch((PsiSwitchBlock)statement);
        }

        public void processSwitch(PsiSwitchBlock expression2) {
            int branchCountExcludingDefault;
            int branchCount = SwitchUtils.calculateBranchCount(expression2);
            int n = branchCountExcludingDefault = branchCount < 0 ? -branchCount - 1 : branchCount;
            if (branchCountExcludingDefault <= SwitchStatementWithTooManyBranchesInspection.this.m_limit) {
                return;
            }
            this.registerError(expression2.getFirstChild(), branchCountExcludingDefault);
        }
    }
}

