/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.CreateDefaultBranchFix;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementsWithoutDefaultInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean m_ignoreFullyCoveredEnums = true;

    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("switch.statements.without.default.display.name", new Object[0]);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SwitchStatementWithoutDefaultBranch";
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("switch.statement.without.default.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFullyCoveredEnums");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                super.visitSwitchStatement(statement);
                int count = SwitchUtils.calculateBranchCount(statement);
                if (count < 0 || statement.getBody() == null) {
                    return;
                }
                boolean infoMode = false;
                if (count == 0 || SwitchStatementsWithoutDefaultInspection.this.m_ignoreFullyCoveredEnums && this.switchStatementIsFullyCoveredEnum(statement)) {
                    if (!isOnTheFly) {
                        return;
                    }
                    infoMode = true;
                }
                String message2 = InspectionGadgetsBundle.message("switch.statements.without.default.problem.descriptor", new Object[0]);
                if (infoMode || isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)SwitchStatementsWithoutDefaultInspection.this.getShortName(), (PsiElement)statement)) {
                    holder.registerProblem((PsiElement)statement, message2, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new CreateDefaultBranchFix((PsiSwitchBlock)statement, null)});
                } else {
                    holder.registerProblem(statement.getFirstChild(), message2, new LocalQuickFix[]{new CreateDefaultBranchFix((PsiSwitchBlock)statement, null)});
                }
            }

            private boolean switchStatementIsFullyCoveredEnum(PsiSwitchStatement statement) {
                PsiExpression expression2 = statement.getExpression();
                if (expression2 == null) {
                    return true;
                }
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                if (aClass == null || !aClass.isEnum()) {
                    return false;
                }
                List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatementBase.class);
                Set constants = StreamEx.of((Collection)labels2).flatCollection(SwitchUtils::findEnumConstants).toSet();
                for (PsiField field : aClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant) || constants.remove(field)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

