/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression2.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read = false;
        private boolean stop = false;
        private PsiReferenceExpression reference = null;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.read || this.stop) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.read || this.stop) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (this.variable.equals(target)) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    this.stop = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
                    if (VariableReadVisitor.isInLoopCondition((PsiExpression)expression2)) {
                        this.stop = true;
                    } else {
                        this.reference = expression2;
                        this.read = true;
                    }
                    return;
                }
            }
            super.visitReferenceExpression(expression2);
        }

        private static boolean isInLoopCondition(PsiExpression expression2) {
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            return statement instanceof PsiLoopStatement;
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            PsiStatement body2 = statement.getThenBranch();
            this.checkCondition(condition2, body2);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            PsiStatement body2 = statement.getBody();
            this.checkCondition(condition2, body2);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            PsiStatement body2 = statement.getBody();
            this.checkCondition(condition2, body2);
        }

        private boolean checkCondition(@Nullable PsiExpression condition2, @Nullable PsiStatement body2) {
            if (body2 == null) {
                return false;
            }
            if (!(condition2 instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand2, body2)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (operands2.length != 2) {
                return false;
            }
            PsiExpression lhs = operands2[0];
            PsiExpression rhs = operands2[1];
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body2);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body2);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression2, @NotNull PsiExpression constantExpression, @NotNull PsiElement body2) {
            PsiType constantType = constantExpression.getType();
            if (constantType == null) {
                return false;
            }
            if (PsiType.DOUBLE.equals((Object)constantType)) {
                Object result = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result) || Double.valueOf(-0.0).equals(result)) {
                    return false;
                }
            }
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            if (target instanceof PsiField) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            VariableReadVisitor visitor = new VariableReadVisitor(variable);
            body2.accept((PsiElementVisitor)visitor);
            if (!visitor.isRead()) {
                return false;
            }
            PsiReferenceExpression reference = visitor.getReference();
            PsiType referenceType = reference.getType();
            if (referenceType == null) {
                return false;
            }
            if (!referenceType.isAssignableFrom(constantType)) {
                return false;
            }
            this.registerError((PsiElement)reference, constantExpression);
            return true;
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text2) {
            this.myText = text2;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression2, this.myText);
        }
    }
}

