/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.InlineVariableFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableInspection
extends BaseInspection {
    public boolean m_ignoreImmediatelyReturnedVariables;
    @Deprecated
    public boolean m_ignoreAnnotatedVariables;
    public boolean m_ignoreAnnotatedVariablesNew = true;

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineVariableFix();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "m_ignoreAnnotatedVariablesNew");
        this.writeBooleanOption(node, "m_ignoreAnnotatedVariablesNew", true);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.local.variable.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.ignore.option", new Object[0]), "m_ignoreImmediatelyReturnedVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.annotation.option", new Object[0]), "m_ignoreAnnotatedVariablesNew");
        return optionsPanel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.local.variable.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiAnnotation annotation;
            int length;
            PsiModifierList list;
            super.visitLocalVariable(variable);
            if (UnnecessaryLocalVariableInspection.this.m_ignoreAnnotatedVariablesNew && (list = variable.getModifierList()) != null && (length = list.getAnnotations().length) > 0 && ((annotation = list.findAnnotation(SuppressWarnings.class.getName())) == null || !JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(list).contains(UnnecessaryLocalVariableInspection.this.getSuppressId()))) {
                return;
            }
            if (VariableAccessUtils.isLocalVariableCopy(variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspection.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspection.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (this.isImmediatelyUsedByBreak((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (this.isImmediatelyAssigned((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (this.isImmediatelyAssignedAsDeclaration((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            }
        }

        private boolean isImmediatelyReturned(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyUsedByBreak(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (containingScope == null) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            PsiBreakStatement breakStatement = (PsiBreakStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiStatement.class), PsiBreakStatement.class);
            if (breakStatement == null) {
                return false;
            }
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(breakStatement.getValueExpression());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            if (!ExpressionUtils.isReferenceTo(returnValue, variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyThrown(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiThrowStatement)) {
                return false;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(throwStatement.getException());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)returnValue).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyAssigned(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)nextStatement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (tokenType != JavaTokenType.EQ) {
                return false;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiArrayAccessExpression) {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            while (nextStatement != null) {
                if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)nextStatement)) {
                    return false;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            return true;
        }

        private boolean isImmediatelyAssignedAsDeclaration(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiStatement.class);
            if (nextStatement instanceof PsiDeclarationStatement) {
                boolean referenceFound = false;
                PsiDeclarationStatement nextDeclarationStatement = (PsiDeclarationStatement)nextStatement;
                for (PsiElement declaration2 : nextDeclarationStatement.getDeclaredElements()) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    if (!(declaration2 instanceof PsiVariable)) continue;
                    PsiVariable nextVariable = (PsiVariable)declaration2;
                    PsiExpression initializer = ParenthesesUtils.stripParentheses(nextVariable.getInitializer());
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
            } else if (nextStatement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
                PsiResourceList resourceList = tryStatement.getResourceList();
                if (resourceList == null) {
                    return false;
                }
                boolean referenceFound = false;
                for (PsiResourceListElement resource : resourceList) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    PsiExpression initializer = ((PsiResourceVariable)resource).getInitializer();
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
                if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)tryStatement.getTryBlock()) || VariableAccessUtils.variableIsUsed(variable, (PsiElement)tryStatement.getFinallyBlock())) {
                    return false;
                }
                for (PsiCatchSection section : tryStatement.getCatchSections()) {
                    if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)section)) continue;
                    return false;
                }
            } else {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            while (nextStatement != null) {
                if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)nextStatement)) {
                    return false;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            return true;
        }

        private boolean isVariableUsedInFollowingDeclarations(PsiVariable variable, PsiDeclarationStatement declarationStatement) {
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length == 1) {
                return false;
            }
            boolean check = false;
            for (PsiElement declaredElement : declaredElements) {
                if (!check && variable.equals(declaredElement)) {
                    check = true;
                    continue;
                }
                if (!VariableAccessUtils.variableIsUsed(variable, declaredElement)) continue;
                return true;
            }
            return false;
        }
    }
}

