/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReturnOfCollectionFieldFix
extends InspectionGadgetsFix {
    private final String myReplacementText;
    private final String myQualifiedClassName;

    private ReturnOfCollectionFieldFix(@NonNls String replacementText, String qualifiedClassName) {
        this.myReplacementText = replacementText;
        this.myQualifiedClassName = qualifiedClassName;
    }

    @Nullable
    public static InspectionGadgetsFix build(PsiReferenceExpression referenceExpression) {
        String text2 = referenceExpression.getText();
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Map")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedMap")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedMap(" + text2 + ')', "java.util.SortedMap");
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableMap(" + text2 + ')', "java.util.Map");
        }
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Collection")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Set")) {
                if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedSet")) {
                    return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedSet(" + text2 + ')', "java.util.SortedSet");
                }
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSet(" + text2 + ')', "java.util.Set");
            }
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.List")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableList(" + text2 + ')', "java.util.List");
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableCollection(" + text2 + ')', "java.util.Collection");
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        return "Make return collection 'unmodifiable'";
    }

    @NotNull
    public String getName() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementText});
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
        this.fixContainingMethodReturnType(referenceExpression);
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)referenceExpression, this.myReplacementText);
    }

    private void fixContainingMethodReturnType(PsiReferenceExpression referenceExpression) {
        String typeText;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
        if (method == null) {
            return;
        }
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement == null) {
            return;
        }
        PsiType type2 = returnTypeElement.getType();
        if (!InheritanceUtil.isInheritor((PsiType)type2, (String)this.myQualifiedClassName)) {
            return;
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        Project project = referenceExpression.getProject();
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        if (aClass == null || this.myQualifiedClassName.equals(aClass.getQualifiedName())) {
            return;
        }
        PsiType[] parameters2 = classType.getParameters();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (parameters2.length > 0) {
            StringBuilder builder = new StringBuilder(this.myQualifiedClassName);
            builder.append('<');
            boolean comma = false;
            for (PsiType parameter2 : parameters2) {
                if (comma) {
                    builder.append(',');
                } else {
                    comma = true;
                }
                builder.append(parameter2.getCanonicalText());
            }
            builder.append('>');
            typeText = builder.toString();
        } else {
            typeText = this.myQualifiedClassName;
        }
        PsiTypeElement newTypeElement = factory.createTypeElementFromText(typeText, (PsiElement)referenceExpression);
        PsiElement replacement = returnTypeElement.replace((PsiElement)newTypeElement);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacement);
        if (this.isOnTheFly()) {
            HighlightUtils.highlightElement(replacement);
        }
    }
}

