/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UseOfAnotherObjectsPrivateFieldInspection
extends BaseInspection {
    public boolean ignoreSameClass = false;
    public boolean ignoreInnerClasses = false;
    public boolean ignoreEquals = false;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return new EncapsulateVariableFix(field.getName());
    }

    @NotNull
    public String getID() {
        return "AccessingNonPublicFieldOfAnotherObject";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("accessing.non.public.field.of.another.object.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("accessing.non.public.field.of.another.object.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JCheckBox box = panel.addCheckboxEx(InspectionGadgetsBundle.message("ignore.accesses.from.the.same.class", new Object[0]), "ignoreSameClass");
        panel.addDependentCheckBox("Ignore accesses from inner classes", "ignoreInnerClasses", box);
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.accesses.from.equals.method", new Object[0]), "ignoreEquals");
        return panel;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "ignoreInnerClasses");
        this.writeBooleanOption(node, "ignoreInnerClasses", false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfAnotherObjectsPrivateFieldVisitor();
    }

    private class UseOfAnotherObjectsPrivateFieldVisitor
    extends BaseInspectionVisitor {
        private UseOfAnotherObjectsPrivateFieldVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiMethod method;
            super.visitReferenceExpression(expression2);
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return;
            }
            if (UseOfAnotherObjectsPrivateFieldInspection.this.ignoreEquals && MethodUtils.isEquals(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class))) {
                return;
            }
            PsiElement referent = expression2.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (UseOfAnotherObjectsPrivateFieldInspection.this.ignoreSameClass) {
                PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
                PsiClass containingClass = field.getContainingClass();
                if (parent != null && (parent.equals(containingClass) || UseOfAnotherObjectsPrivateFieldInspection.this.ignoreInnerClasses && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)parent, (boolean)true))) {
                    return;
                }
            }
            if (!field.hasModifierProperty("private") && !field.hasModifierProperty("protected")) {
                return;
            }
            if (field.hasModifierProperty("static")) {
                return;
            }
            PsiElement fieldNameElement = expression2.getReferenceNameElement();
            if (fieldNameElement == null) {
                return;
            }
            this.registerError(fieldNameElement, field);
        }
    }
}

