/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class BadExceptionDeclaredInspection
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.Throwable", "java.lang.Exception", "java.lang.Error", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ClassCastException", "java.lang.ArrayIndexOutOfBoundsException");
    public boolean ignoreTestCases = false;
    public boolean ignoreLibraryOverrides = false;

    public BadExceptionDeclaredInspection() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            this.exceptions.addAll(strings);
            this.exceptionsString = "";
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        ListTable table = new ListTable(new ListWrappingTableModel((List)((Object)this.exceptions), InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.exception.class", new Object[0]), "java.lang.Throwable");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel.add((Component)tablePanel, constraints);
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.exceptions.declared.on.library.override.option", new Object[0]), (InspectionProfileEntry)this, "ignoreLibraryOverrides");
        constraints.weighty = 0.0;
        constraints.gridy = 1;
        panel.add((Component)checkBox2, constraints);
        return panel;
    }

    @NotNull
    public String getID() {
        return "ProhibitedExceptionDeclared";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("bad.exception.declared.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("bad.exception.declared.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionDeclaredVisitor();
    }

    private class BadExceptionDeclaredVisitor
    extends BaseInspectionVisitor {
        private BadExceptionDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiJavaCodeReferenceElement[] references;
            super.visitMethod(method);
            if (BadExceptionDeclaredInspection.this.ignoreLibraryOverrides && LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
                PsiClass thrownClass;
                String qualifiedName;
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiClass) || (qualifiedName = (thrownClass = (PsiClass)element).getQualifiedName()) == null || !BadExceptionDeclaredInspection.this.exceptions.contains(qualifiedName)) continue;
                this.registerError((PsiElement)reference, reference);
            }
        }
    }
}

