/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SideEffectVisitor;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatchMayIgnoreExceptionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String IGNORED_PARAMETER_NAME = "ignored";
    public boolean m_ignoreCatchBlocksWithComments = true;
    public boolean m_ignoreNonEmptyCatchBlock = true;
    public boolean m_ignoreUsedIgnoredName = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.comments", new Object[0]), "m_ignoreCatchBlocksWithComments");
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.nonempty", new Object[0]), "m_ignoreNonEmptyCatchBlock");
        panel.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.ignored.used", new Object[0]), "m_ignoreUsedIgnoredName");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitTryStatement(@NotNull PsiTryStatement statement) {
                PsiCatchSection[] catchSections;
                super.visitTryStatement(statement);
                for (PsiCatchSection section : catchSections = statement.getCatchSections()) {
                    this.checkCatchSection(section);
                }
            }

            private void checkCatchSection(PsiCatchSection section) {
                PsiParameter parameter2 = section.getParameter();
                if (parameter2 == null) {
                    return;
                }
                PsiIdentifier identifier = parameter2.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                String parameterName = parameter2.getName();
                if (parameterName == null) {
                    return;
                }
                if (PsiUtil.isIgnoredName((String)parameterName)) {
                    if (!CatchMayIgnoreExceptionInspection.this.m_ignoreUsedIgnoredName && VariableAccessUtils.variableIsUsed((PsiVariable)parameter2, (PsiElement)section)) {
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.used.message", new Object[0]), new LocalQuickFix[0]);
                    }
                    return;
                }
                if ((parameterName.equals("expected") || parameterName.equals("ok")) && TestUtils.isInTestSourceContent((PsiElement)section)) {
                    return;
                }
                PsiElement catchToken = section.getFirstChild();
                if (catchToken == null) {
                    return;
                }
                PsiCodeBlock block = section.getCatchBlock();
                if (block == null) {
                    return;
                }
                SuppressForTestsScopeFix fix2 = SuppressForTestsScopeFix.build(CatchMayIgnoreExceptionInspection.this, (PsiElement)section);
                if (ControlFlowUtils.isEmpty((PsiElement)block, CatchMayIgnoreExceptionInspection.this.m_ignoreCatchBlocksWithComments, true)) {
                    holder.registerProblem(catchToken, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.empty.message", new Object[0]), new LocalQuickFix[]{new EmptyCatchBlockFix(), fix2});
                } else if (!VariableAccessUtils.variableIsUsed((PsiVariable)parameter2, (PsiElement)section)) {
                    if (!(CatchMayIgnoreExceptionInspection.this.m_ignoreNonEmptyCatchBlock || CatchMayIgnoreExceptionInspection.this.m_ignoreCatchBlocksWithComments && PsiTreeUtil.getChildOfType((PsiElement)block, PsiComment.class) != null)) {
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.unused.message", new Object[0]), new LocalQuickFix[]{new RenameFix(CatchMayIgnoreExceptionInspection.IGNORED_PARAMETER_NAME, false, false), fix2});
                    }
                } else if (this.mayIgnoreVMException(parameter2, block)) {
                    holder.registerProblem(catchToken, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.vm.ignored.message", new Object[0]), new LocalQuickFix[]{fix2});
                }
            }

            private boolean mayIgnoreVMException(PsiParameter parameter2, PsiCodeBlock block) {
                Consumer<DfaMemoryState> stateAdjuster;
                PsiType type2 = parameter2.getType();
                if (!(type2.equalsToText("java.lang.Throwable") || type2.equalsToText("java.lang.Exception") || type2.equalsToText("java.lang.RuntimeException") || type2.equalsToText("java.lang.Error"))) {
                    return false;
                }
                String className = type2.equalsToText("java.lang.Error") ? "java.lang.StackOverflowError" : "java.lang.NullPointerException";
                PsiClassType exception = JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createTypeByFQClassName(className, parameter2.getResolveScope());
                PsiClass exceptionClass = exception.resolve();
                if (exceptionClass == null) {
                    return false;
                }
                StandardDataFlowRunner runner = new StandardDataFlowRunner(false, (PsiElement)block);
                DfaValueFactory factory = runner.getFactory();
                DfaVariableValue exceptionVar = factory.getVarFactory().createVariableValue((PsiVariable)parameter2);
                DfaVariableValue stableExceptionVar = factory.getVarFactory().createVariableValue(new LightParameter("tmp", (PsiType)exception, (PsiElement)block));
                IgnoredExceptionVisitor visitor = new IgnoredExceptionVisitor(parameter2, block, exceptionClass, stableExceptionVar);
                return runner.analyzeCodeBlock(block, visitor, stateAdjuster = state -> {
                    state.applyCondition(factory.createCondition(exceptionVar, DfaRelationValue.RelationType.EQ, stableExceptionVar));
                    state.applyCondition(factory.createCondition(exceptionVar, DfaRelationValue.RelationType.IS, factory.createTypeValue((PsiType)exception, Nullability.NOT_NULL)));
                }) == RunnerResult.OK;
            }
        };
    }

    private static class EmptyCatchBlockFix
    implements LocalQuickFix {
        private EmptyCatchBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent;
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            PsiIdentifier identifier = parameter2.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier(CatchMayIgnoreExceptionInspection.IGNORED_PARAMETER_NAME);
            identifier.replace((PsiElement)newIdentifier);
        }
    }

    static class IgnoredExceptionVisitor
    extends SideEffectVisitor {
        @NotNull
        private final PsiParameter myParameter;
        @NotNull
        private final PsiCodeBlock myBlock;
        @NotNull
        private final List<PsiMethod> myMethods;
        @NotNull
        private final DfaVariableValue myExceptionVar;

        IgnoredExceptionVisitor(@NotNull PsiParameter parameter2, @NotNull PsiCodeBlock block, @NotNull PsiClass exceptionClass, @NotNull DfaVariableValue exceptionVar) {
            this.myParameter = parameter2;
            this.myBlock = block;
            this.myExceptionVar = exceptionVar;
            this.myMethods = ((StreamEx)StreamEx.of((Object[])new String[]{"getMessage", "getLocalizedMessage", "getCause"}).flatArray(name -> exceptionClass.findMethodsByName(name, true)).filter(m -> m.getParameterList().isEmpty())).toList();
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaValue qualifier;
            if (this.myMethods.contains(instruction.getTargetMethod()) && memState.areEqual(qualifier = memState.peek(), this.myExceptionVar)) {
                memState.pop();
                memState.push(runner.getFactory().getConstFactory().getNull());
                return IgnoredExceptionVisitor.nextInstruction(instruction, runner, memState);
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @Override
        protected boolean isModificationAllowed(DfaVariableValue variable) {
            PsiModifierListOwner owner = variable.getPsiVariable();
            return owner == this.myParameter || owner != null && PsiTreeUtil.isAncestor((PsiElement)this.myBlock, (PsiElement)owner, (boolean)false);
        }
    }
}

