/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class CheckedExceptionClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("checked.exception.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("checked.exception.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CheckedExceptionClassVisitor();
    }

    private static class CheckedExceptionClassVisitor
    extends BaseInspectionVisitor {
        private CheckedExceptionClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

