/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EmptyFinallyBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("empty.finally.block.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("empty.finally.block.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean canDeleteTry = (Boolean)infos[0];
        if (canDeleteTry.booleanValue()) {
            return new RemoveTryFinallyBlockFix();
        }
        return new RemoveFinallyBlockFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyFinallyBlockVisitor();
    }

    private static class EmptyFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyFinallyBlockVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiElement[] children;
            super.visitTryStatement(statement);
            PsiCodeBlock finallyBlock = statement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (!finallyBlock.isEmpty()) {
                return;
            }
            for (PsiElement child : children = statement.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                boolean canDeleteTry = statement.getCatchBlocks().length == 0 && statement.getResourceList() == null;
                this.registerError(child, canDeleteTry);
                return;
            }
        }
    }

    private static class RemoveFinallyBlockFix
    extends InspectionGadgetsFix {
        private RemoveFinallyBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("remove.finally.block.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
            if (tryStatement == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally((PsiElement)finallyBlock);
        }

        private static void deleteUntilFinally(PsiElement element) {
            PsiJavaToken keyword;
            IElementType tokenType;
            if (element instanceof PsiJavaToken && (tokenType = (keyword = (PsiJavaToken)element).getTokenType()).equals(JavaTokenType.FINALLY_KEYWORD)) {
                keyword.delete();
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally(element.getPrevSibling());
            if (!(element instanceof PsiWhiteSpace)) {
                element.delete();
            }
        }
    }

    private static class RemoveTryFinallyBlockFix
    extends InspectionGadgetsFix {
        private RemoveTryFinallyBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("remove.try.finally.block.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
            if (tryStatement == null || tryStatement.getResourceList() != null || tryStatement.getParent() == null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!(tryStatement.getParent() instanceof PsiCodeBlock)) {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
                tryBlock = Objects.requireNonNull(tryStatement.getTryBlock());
            }
            PsiElement first = tryBlock.getFirstBodyElement();
            PsiElement last = tryBlock.getLastBodyElement();
            if (first != null && last != null) {
                tryStatement.getParent().addRangeAfter(first, last, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }
}

