/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExtendsThrowableInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("extends.throwable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiAnonymousClass) {
            return InspectionGadgetsBundle.message("anonymous.extends.throwable.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("extends.throwable.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsThrowableVisitor();
    }

    private static class ExtendsThrowableVisitor
    extends BaseInspectionVisitor {
        private ExtendsThrowableVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum() || aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            String superclassName = superClass.getQualifiedName();
            if (!"java.lang.Throwable".equals(superclassName)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

