/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class FinallyBlockCannotCompleteNormallyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "finally";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinallyBlockCannotCompleteNormallyVisitor();
    }

    private static boolean isInMainMethod(@NotNull PsiStatement statement) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
        if (method == null) {
            return false;
        }
        if (!"main".equals(method.getName())) {
            return false;
        }
        PsiModifierList modifierList = method.getModifierList();
        if (!modifierList.hasExplicitModifier("static") || !modifierList.hasExplicitModifier("public") || method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiParameter parameter2 = parameters2[0];
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)parameter2.getType(), PsiArrayType.class);
        if (arrayType == null) {
            return false;
        }
        PsiType componentType = arrayType.getDeepComponentType();
        return "java.lang.String".equals(componentType.getCanonicalText());
    }

    private static class FinallyBlockCannotCompleteNormallyVisitor
    extends BaseInspectionVisitor {
        private FinallyBlockCannotCompleteNormallyVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiElement[] children;
            super.visitTryStatement(statement);
            PsiCodeBlock finallyBlock = statement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (FinallyBlockCannotCompleteNormallyInspection.isInMainMethod((PsiStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
                return;
            }
            for (PsiElement child : children = statement.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                this.registerError(child, new Object[0]);
                return;
            }
        }
    }
}

