/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceofCatchParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("instanceof.catch.parameter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("instanceof.catch.parameter.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofCatchParameterVisitor();
    }

    private static class InstanceofCatchParameterVisitor
    extends BaseInspectionVisitor {
        private InstanceofCatchParameterVisitor() {
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
            super.visitInstanceOfExpression(exp);
            if (!ControlFlowUtils.isInCatchBlock((PsiElement)exp)) {
                return;
            }
            PsiTypeElement typeElement = exp.getCheckType();
            if (typeElement == null || !InheritanceUtil.isInheritor((PsiType)typeElement.getType(), (String)"java.lang.Throwable")) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(exp.getOperand());
            if (!(operand2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)operand2;
            PsiElement referent = ref.resolve();
            if (!(referent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)referent;
            if (!(parameter2.getDeclarationScope() instanceof PsiCatchSection)) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }
    }
}

