/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryStatementWithMultipleResourcesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("try.statement.with.multiple.resources.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitTryWithResourcesVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitTryWithResourcesFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiCatchSection[] catchSections;
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null || resourceList.getResourceVariablesCount() <= 1) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        StringBuilder newTryStatementText = new StringBuilder();
        int count = 0;
        for (PsiResourceListElement resource : resourceList) {
            if (count > 0) {
                newTryStatementText.append("{\n");
            }
            ++count;
            newTryStatementText.append("try (").append(tracker.text((PsiElement)resource)).append(")");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        newTryStatementText.append(tracker.text((PsiElement)tryBlock));
        for (int i = 1; i < count; ++i) {
            newTryStatementText.append("\n}");
        }
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            newTryStatementText.append(tracker.text((PsiElement)catchSection));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatementText.append("finally").append(tracker.text((PsiElement)finallyBlock));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)tryStatement, newTryStatementText.toString(), tracker);
    }

    private static boolean isAcceptable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        return resourceList.getResourceVariablesCount() > 1;
    }

    private static class SplitTryWithResourcesFix
    extends InspectionGadgetsFix {
        private SplitTryWithResourcesFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            TryStatementWithMultipleResourcesInspection.doFixImpl(descriptor.getPsiElement());
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("try.statement.with.multiple.resources.quickfix", new Object[0]);
        }
    }

    private static class SplitTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private SplitTryWithResourcesVisitor() {
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.TRY_KEYWORD && TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            super.visitResourceList(resourceList);
            if (TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)resourceList)) {
                this.registerError((PsiElement)resourceList, new Object[0]);
            }
        }
    }
}

